/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions.condition;

import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.transform.code.JavaScriptCodeEval;
import com.ats.script.Script;
import com.ats.script.actions.condition.IExecuteCondition;
import com.google.gson.JsonObject;

public class ExecuteCondition
implements IExecuteCondition {
    private CalculatedValue code;
    private boolean escapeQuote = false;

    public ExecuteCondition() {
    }

    public ExecuteCondition(Script script, String ifCode) {
        this(script, ifCode, false);
    }

    public ExecuteCondition(Script script, String ifCode, boolean escapeQuote) {
        this(new CalculatedValue(script, ifCode), escapeQuote);
    }

    public ExecuteCondition(CalculatedValue code, boolean escapeQuote) {
        this.code = code;
        this.escapeQuote = escapeQuote;
    }

    @Override
    public void updateLegacy() {
        String separator;
        String codeData = this.code.getData();
        String[] data = codeData.split(separator = "==");
        if (data.length != 2) {
            separator = "!=";
            data = codeData.split(separator);
        }
        if (data.length == 2) {
            String varName = data[0].trim();
            if (this.code.getScript().getVariable(varName) != null) {
                this.code.updateData("'$var(" + varName + ")' " + separator + " '" + data[1].trim() + "'");
            }
        }
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder sb = new StringBuilder("opt").append("(").append(this.code.getJavaCode()).append(", ").append(this.escapeQuote).append("), ");
        return sb;
    }

    @Override
    public JsonObject getLog(JsonObject jsonObject) {
        return jsonObject;
    }

    @Override
    public boolean isPassed() {
        String data = this.code.getCalculated();
        if (this.escapeQuote) {
            data = data.replace("\\'", "'");
            data = data.replace("'", "\\'");
        } else {
            data = data.replace("\\\"", "\"");
            data = data.replace("\"", "\\\"");
        }
        String eval = new JavaScriptCodeEval(data).eval();
        return "true".equals(eval);
    }

    @Override
    public void setPassed(boolean value) {
    }

    public void setCode(CalculatedValue code) {
        this.code = code;
    }

    public CalculatedValue getCode() {
        return this.code;
    }

    @Override
    public boolean isEscapeQuote() {
        return this.escapeQuote;
    }

    @Override
    public void setEscapeQuote(boolean value) {
        this.escapeQuote = value;
    }
}

