/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Constants {
    public static final String COMMAND_LINE_SUITE_NAME = "command line suite";
    public static final String ALERT_BOX_ACTION_ELEMENT_TAG = "dialog";
    public static final long ONE_SECOND = 1000L;
    public static final byte ONE_HOUR = 1;
    public static final String EMPTY_VALUE_SIGN = "#EMPTY#";
    public static final String NO_DATA_SIGN = "NO_DATA_AVAILABLE";
    public static final Set<String> EMPTY_SIGNS = Set.of("#EMPTY#", "NO_DATA_AVAILABLE");
    public static final String EMPTY_VALUE = "<span style='color: #E3B32D;'>[Empty]</span>";
    public static final UnaryOperator<String> CONDITIONALLY_REPLACE_TO_EMPTY_REPRESENTATION = value -> StringUtils.isBlank((CharSequence)value) || EMPTY_SIGNS.contains(value) ? EMPTY_VALUE : value;
    public static final ExecutionGroupStyle DEFAULT_GROUP_STYLE = new ExecutionGroupStyle("#778899", "#B0C4DE");
    public static final Map<String, ExecutionGroupStyle> EXECUTION_GROUPS_STYLE = Map.of("gray", new ExecutionGroupStyle("#404040", "#A6A6A6"), "red", new ExecutionGroupStyle("#800000", "#E66666"), "orange", new ExecutionGroupStyle("#8D4C00", "#F3B266"), "yellow", new ExecutionGroupStyle("#997200", "#FFD866"), "green", new ExecutionGroupStyle("#446D00", "#AAD366"), "blue", new ExecutionGroupStyle("#1F5B83", "#85C1E9"), "purple", new ExecutionGroupStyle("#422C7F", "#A892E5"));

    private Constants() {
    }

    public record ExecutionGroupStyle(String textColor, String backgroundColor) {
    }

    public static class StatusIcons {
        public static String FAIL_ICON = "result-failed-icon";
        public static String FAIL_TRANSPARENT_ICON = "result-failed-icon-transparent";
        public static String FAIL_PASS_ICON = "result-fail-pass-icon";
        public static String PASS_ICON = "result-pass-icon";
        public static String PASS_TRANSPARENT_ICON = "result-pass-icon-transparent";
        public static String PASS_CONTINUE_ICON = "result-pass-icon-continue";

        private StatusIcons() {
        }
    }

    public static enum Status {
        FAIL(false, "FAIL", StatusIcons.FAIL_ICON, StatusIcons.FAIL_ICON),
        PASS(true, "PASS", StatusIcons.PASS_ICON, StatusIcons.PASS_TRANSPARENT_ICON);

        private final boolean booleanValue;
        private final String value;
        private final String mainReportIcon;
        private final String summaryReportIcon;

        private Status(boolean booleanValue, String value, String icon, String transparentIcon) {
            this.booleanValue = booleanValue;
            this.value = value;
            this.mainReportIcon = icon;
            this.summaryReportIcon = transparentIcon;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public String getValue() {
            return this.value;
        }

        public String getMainReportIcon() {
            return this.mainReportIcon;
        }

        public String getSummaryReportIcon() {
            return this.summaryReportIcon;
        }

        public static Status fromValue(String value) {
            Validate.notBlank((CharSequence)value);
            return Stream.of(Status.values()).filter(status -> status.getValue().equals(value)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("invalid status %s", value)));
        }
    }

    public static enum SummaryStatus {
        FAIL("0", StatusIcons.FAIL_ICON, StatusIcons.FAIL_ICON),
        PASS("1", StatusIcons.PASS_ICON, StatusIcons.PASS_TRANSPARENT_ICON),
        PASS_CONTINUE("2", StatusIcons.PASS_CONTINUE_ICON, StatusIcons.PASS_CONTINUE_ICON);

        private final String numericValue;
        private final String mainReportIcon;
        private final String summaryReportIcon;

        private SummaryStatus(String numericValue, String icon, String transparentIcon) {
            this.numericValue = numericValue;
            this.mainReportIcon = icon;
            this.summaryReportIcon = transparentIcon;
        }

        public String getNumericValue() {
            return this.numericValue;
        }

        public String getMainReportIcon() {
            return this.mainReportIcon;
        }

        public String getSummaryReportIcon() {
            return this.summaryReportIcon;
        }

        public static SummaryStatus fromNumericValue(String numericValue) {
            Validate.notBlank((CharSequence)numericValue);
            return Stream.of(SummaryStatus.values()).filter(summaryStatus -> summaryStatus.getNumericValue().equals(numericValue)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("invalid summary status %s", numericValue)));
        }
    }

    public static enum ReportDetailLevel {
        NOT_AVAILABLE(-1, "Not available"),
        DISABLED(0, "Disabled"),
        EXECUTION_REPORT(1, "Execution report"),
        DETAILED_EXECUTION_REPORT(2, "Detailed execution report"),
        DETAILED_EXECUTION_REPORT_WITH_SCREENSHOTS(3, "Detailed execution report with screenshots");

        private final byte levelValue;
        private final String description;

        private ReportDetailLevel(byte levelValue, String description) {
            this.levelValue = levelValue;
            this.description = description;
        }

        public int getLevelValue() {
            return this.levelValue;
        }

        public String getDescription() {
            return this.description;
        }

        public static ReportDetailLevel fromLevelValue(int level) {
            return Stream.of(ReportDetailLevel.values()).filter(detailLevel -> detailLevel.getLevelValue() == level).findFirst().orElse(NOT_AVAILABLE);
        }
    }
}

