/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions;

import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.Constants;
import com.ats.tools.report.actions.HtmlReportActionAssert;
import com.ats.tools.report.models.Action;
import com.ats.tools.report.models.OperatorsWithIcons;
import com.ats.tools.report.utils.HtmlActionUtils;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class HtmlReportActionAssertCount
extends HtmlReportActionAssert {
    public HtmlReportActionAssertCount(String template, Action action) {
        this.result = template.replace("${searchedElementHeader}", HtmlActionUtils.buildSearchedElementHeader(action));
        this.result = this.result.replace("${operation}", this.buildOperation(action));
        this.result = this.result.replace("${searchedElement}", Objects.nonNull(action.getActionElement()) ? HtmlActionUtils.buildSearchedElementData(action) : "");
        this.result = this.result.replace("${actualLabel}", "Found");
        this.result = this.result.replace("${expectedLabel}", "Expected");
    }

    private String buildOperation(Action action) {
        if (StringUtils.isBlank((CharSequence)action.getValue()) && StringUtils.isBlank((CharSequence)action.getData())) {
            return "";
        }
        try {
            HtmlReportActionAssert.ValueAssertValue value = (HtmlReportActionAssert.ValueAssertValue)this.gson.fromJson(action.getValue(), HtmlReportActionAssert.ValueAssertValue.class);
            String operator = OperatorsWithIcons.getIconForOperator(value.operator());
            String expected = (String)Constants.CONDITIONALLY_REPLACE_TO_EMPTY_REPRESENTATION.apply(value.value());
            String actual = (String)Constants.CONDITIONALLY_REPLACE_TO_EMPTY_REPRESENTATION.apply(action.getData());
            return "<div style=\"max-width: 45%\">\n    <div class=\"assertLib\">${actualLabel}</div>\n    <div style=\"min-height: 16px\">${actual}</div>\n</div>\n<div style=\"margin:0 10px\">${operator}</div>\n<div style=\"max-width: 45%\">\n    <div class=\"assertLib\">${expectedLabel}</div>\n    <div style=\"min-height: 16px\">${expected}</div>\n</div>".replace("${expected}", expected).replace("${actual}", actual).replace("${operator}", operator);
        }
        catch (JsonSyntaxException e) {
            AtsLogger.printLog("cannot parse assert count value", String.format("script %s, line %d; error msg %s", action.getScript(), action.getLine(), e.getMessage()));
            return "";
        }
    }
}

