/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions.callscript;

import com.ats.tools.report.actions.callscript.ActionCallscriptData;
import com.ats.tools.report.actions.callscript.SearchedElementData;
import com.ats.tools.report.models.Action;
import com.ats.tools.report.utils.HtmlActionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public record SearchedElementActionCallscriptData(SearchedElementData elementData, Action action) implements ActionCallscriptData
{
    @Override
    public String getHeader() {
        return HtmlActionUtils.buildSearchedElementHeader(this.action);
    }

    @Override
    public String getBody() {
        List<SearchedElementData> searchedElements = this.getOrderedSearchedElementList();
        if (CollectionUtils.isEmpty(searchedElements)) {
            return "";
        }
        String content = this.createBodyContent(searchedElements);
        return "<div class=\"action-callscript-content ${active}\">\n    ${content}\n</div>".replace("${content}", content).replace("${active}", Objects.equals(Integer.toString(-30), this.action().getError()) ? "action-callscript-inactive-search-element-content" : "");
    }

    private String createBodyContent(List<SearchedElementData> searchedElements) {
        String notFoundElement = Objects.equals(Integer.toString(-1), this.action.getError()) && Objects.nonNull(this.action.getActionElement()) ? this.action.getActionElement().getRawCriterias() : null;
        StringBuilder html = new StringBuilder();
        html.append(this.buildHtml(searchedElements.getFirst(), notFoundElement, false, 0));
        if (searchedElements.size() > 1) {
            for (int i = 1; i < searchedElements.size(); ++i) {
                html.append(this.buildHtml(searchedElements.get(i), notFoundElement, true, i));
            }
        }
        return html.toString();
    }

    private String buildHtml(SearchedElementData elementData, String notFoundElement, boolean parent, int indentRatio) {
        return "<div style=\"display: flex; margin: 0px 0px 5px ${margin}px;\">\n    ${parentConnection}\n    <div style=\"margin-right: 10px\">${tag}</div>\n    ${criteria}\n    &nbsp;\n    ${notFound}\n</div>".replace("${tag}", elementData.tag()).replace("${criteria}", CollectionUtils.isNotEmpty(elementData.criterias()) ? this.buildHtmlCriteria(elementData.criterias().getFirst()) : "").replace("${parentConnection}", parent ? "&rdsh;&nbsp;" : "").replace("${notFound}", elementData.equalByTagAndCriterias(notFoundElement) ? "<div class='action-callscript-element-not-found-triangle-left'></div><div class='action-callscript-element-not-found'>not found</div>" : "").replace("${margin}", Integer.toString(indentRatio == 0 ? 0 : (indentRatio - 1) * 10 + 6 * indentRatio));
    }

    private String buildHtmlCriteria(Map<String, String> criteria) {
        String key = criteria.keySet().iterator().next();
        String value = criteria.values().iterator().next();
        return "[&nbsp;<span class=\"action-callscript-criteria-key\">${key}:</span> ${value}&nbsp;]".replace("${key}", key).replace("${value}", value);
    }

    private List<SearchedElementData> getOrderedSearchedElementList() {
        ArrayList<SearchedElementData> elements = new ArrayList<SearchedElementData>();
        elements.add(this.elementData);
        SearchedElementData parent = this.elementData.parent();
        while (Objects.nonNull(parent)) {
            elements.add(parent);
            parent = parent.parent();
        }
        return elements.reversed();
    }
}

