/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions.callscript;

import com.ats.tools.report.actions.callscript.ActionCallscriptData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public record TablePatametersActionCallscriptData(List<Map<String, Map<String, String>>> rows) implements ActionCallscriptData
{
    @Override
    public String getHeader() {
        return "Table parameters";
    }

    @Override
    public String getBody() {
        return "<div class=\"action-callscript-content\">\n    ${content}\n</div>".replace("${content}", CollectionUtils.isNotEmpty(this.rows) ? this.createTableContent() : "");
    }

    private String createTableContent() {
        StringBuilder htmlRows = new StringBuilder();
        int maxCellsInRows = this.getMaxCellsInRows();
        for (int i = 0; i < this.rows.size(); ++i) {
            htmlRows.append(this.createRow(this.rows.get(i), maxCellsInRows, i + 1 == this.rows().size()));
        }
        return htmlRows.toString();
    }

    private String createRow(Map<String, Map<String, String>> row, int maxCellsInRows, boolean lastRow) {
        if (MapUtils.isEmpty(row)) {
            return "";
        }
        ArrayList cellValues = new ArrayList(((Map)new ArrayList(CollectionUtils.emptyIfNull(row.values())).getFirst()).entrySet());
        cellValues.sort(Comparator.comparingInt(entry -> Integer.parseInt(StringUtils.getDigits((String)((String)entry.getKey())))));
        StringBuilder htmlCells = new StringBuilder();
        for (int i = 0; i < cellValues.size(); ++i) {
            int flexGrowRatio = i + 1 == cellValues.size() ? maxCellsInRows : 1;
            htmlCells.append(this.createCell((Map.Entry)cellValues.get(i), flexGrowRatio));
            --maxCellsInRows;
        }
        return "<div class=\"action-callscript-table-row\" ${border}>\n    <div class=\"action-callscript-table-row-iter-cell\">${iteration}</div>\n    ${cells}\n</div>\n".replace("${cells}", htmlCells.toString()).replace("${border}", lastRow ? "style='border-bottom: none'" : "").replace("${iteration}", row.keySet().iterator().next());
    }

    private String createCell(Map.Entry<String, String> cellData, int flexGrowRatio) {
        return "<div class=\"action-callscript-table-row-cell\" style=\"flex-grow: ${ratio}\">\n    <div class=\"action-callscript-table-row-cell-param\">param ${paramNumber}</div>\n    <div>${data}</div>\n</div>\n".replace("${data}", cellData.getValue()).replace("${paramNumber}", cellData.getKey()).replace("${ratio}", Integer.toString(flexGrowRatio));
    }

    private int getMaxCellsInRows() {
        return this.rows().stream().mapToInt(row -> ((Map)new ArrayList(CollectionUtils.emptyIfNull(row.values())).getFirst()).size()).max().getAsInt();
    }
}

