/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.utils;

import com.ats.tools.report.models.Action;
import com.ats.tools.report.models.TestInfo;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class HtmlActionUtils {
    private static final Pattern DIALOG_BOX_CRITERIA_PATTERN = Pattern.compile("ALERT \\[(.*?)]");
    private static final String SEARCHED_ELEMENT_TEMPLATE = "<div style='margin-right: 5px;'>\n    ${criterias}\n    <div style='font-size: 12px; color: rgba(104, 112, 125, 0.88); margin-top: 6px;'>\n        <div>Elements found: ${foundElements}</div>\n        <div> Search duration: ${searchedDuration} ms</div>\n    </div>\n</div>\n";

    public static String buildElementHeaderErrorTag(String error) {
        return switch (Integer.parseInt(error)) {
            case -20 -> "<div class='searched-element-error'>file_not_found #-20</div>";
            case -13 -> "<div class='searched-element-error'>java_error #-13</div>";
            default -> "";
        };
    }

    public static String buildActionFirstColumnHeaderErrorTag(String error) {
        return switch (Integer.parseInt(error)) {
            case -5 -> "<div class='searched-element-error'>property_not_found #-5</div>";
            case -30 -> "<div class='searched-element-error'>subscript_not_found #-30</div>";
            case -18 -> "<div class='searched-element-error'>java_exception #-18</div>";
            case -29 -> "<div class='searched-element-error'>syntax_error #-29</div>";
            default -> "";
        };
    }

    public static String buildSearchedElementHeader(Action action) {
        String element = "element";
        String errorElement = "element";
        if (Objects.nonNull(action.getActionElement()) && "dialog".equals(action.getActionElement().getTag())) {
            element = "dialog box";
            errorElement = "dialog_box";
        }
        String header = switch (action.getError()) {
            case "-1" -> "<div>Searched ${element}</div><div class='searched-element-error'>${errorElement}_not_found #-1</div>";
            case "-2" -> "<div>Searched ${element}</div><div class='searched-element-error'>${errorElement}_not_visible #-2</div>";
            case "-3" -> "<div>Searched ${element}</div><div class='searched-element-error'>${errorElement}_not_interactable #-3</div>";
            default -> "Searched ${element}";
        };
        return header.replace("${element}", element).replace("${errorElement}", errorElement);
    }

    public static String buildSearchedElementData(Action action) {
        Matcher matcher;
        String criterias = action.getActionElement().getCriterias();
        if (StringUtils.isNotBlank((CharSequence)criterias) && "dialog".equals(action.getActionElement().getTag()) && (matcher = DIALOG_BOX_CRITERIA_PATTERN.matcher(criterias)).find()) {
            criterias = matcher.group(1);
        }
        return SEARCHED_ELEMENT_TEMPLATE.replace("${criterias}", criterias).replace("${foundElements}", Integer.toString(action.getActionElement().getFoundElements())).replace("${searchedDuration}", Integer.toString(action.getActionElement().getSearchDuration()));
    }

    public static String getActionUrl(Action action, TestInfo testInfo) {
        return testInfo.getProject().getProjectId() + "/script/" + action.getScript() + "/" + action.getLine();
    }

    public static String getActionUrl(TestInfo testInfo, String scriptName, String line) {
        return testInfo.getProject().getProjectId() + "/script/" + scriptName + "/" + line;
    }

    public static String buildLink(String link) {
        String linkUrl = link.startsWith("http") ? link : String.format("%s%s", "http://", link);
        return String.format("<a href=\"%s\" target=\"_blank\">%s</a>", linkUrl, link);
    }
}

