/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.java;

import com.ats.executor.java.IJavaCodeExecuter;
import com.ats.executor.java.JavaByteObject;
import com.ats.executor.java.JavaStringObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JavaCodeEval {
    private static final String ATS_EXECUTOR_CLASS = "AtsJavaExecutor";
    private String contentCode;

    public JavaCodeEval(String code) {
        if (code.endsWith(";")) {
            code = code.substring(0, code.length() - 1);
        }
        this.contentCode = "public class AtsJavaExecutor implements com.ats.executor.java.IJavaCodeExecuter {@Override\npublic String execute(){return String.valueOf(" + code + ");}}";
    }

    public String eval() throws Exception {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaByteObject byteObject = new JavaByteObject(ATS_EXECUTOR_CLASS);
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnostics, null, null);
        JavaFileManager fileManager = JavaCodeEval.createFileManager(standardFileManager, byteObject);
        List<JavaStringObject> javaObjs = Arrays.asList(new JavaStringObject(ATS_EXECUTOR_CLASS, this.contentCode));
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, javaObjs);
        if (!task.call().booleanValue()) {
            StringBuilder sj = new StringBuilder(" [");
            diagnostics.getDiagnostics().forEach(d -> sj.append(" ").append(d.getMessage(null)));
            return "#CodeEvalError#" + sj.append(" ]").toString();
        }
        fileManager.close();
        ClassLoader inMemoryClassLoader = JavaCodeEval.createClassLoader(byteObject);
        Class<?> exec = inMemoryClassLoader.loadClass(ATS_EXECUTOR_CLASS);
        return ((IJavaCodeExecuter)exec.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).execute();
    }

    private static JavaFileManager createFileManager(StandardJavaFileManager fileManager, final JavaByteObject byteObject) {
        return new ForwardingJavaFileManager<StandardJavaFileManager>(fileManager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                return byteObject;
            }
        };
    }

    private static ClassLoader createClassLoader(final JavaByteObject byteObject) {
        return new ClassLoader(){

            @Override
            public Class<?> findClass(String name) throws ClassNotFoundException {
                byte[] bytes = byteObject.getBytes();
                return this.defineClass(name, bytes, 0, bytes.length);
            }
        };
    }
}

