/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator;

import com.ats.generator.ATS;
import com.ats.generator.AntCompiler;
import com.ats.generator.GeneratorReport;
import com.ats.generator.events.ScriptProcessedEvent;
import com.ats.generator.events.ScriptProcessedNotifier;
import com.ats.generator.parsers.Lexer;
import com.ats.script.AtsScript;
import com.ats.script.Project;
import com.ats.tools.Utils;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;

public class Generator
implements ScriptProcessedEvent {
    private GeneratorReport genReport;
    private Lexer lexer;
    private List<Path> filesList;
    private Project project;
    private int remainingScripts = 0;

    public static void main(String[] args) throws TransformerException, IOException, ParserConfigurationException {
        ATS.logInfo("Java version : " + System.getProperty("java.version"));
        ATS.logInfo(StringUtils.repeat((String)"-", (int)72));
        System.setErr(new PrintStream(new NoWarningOutputStream(System.err), true));
        ATS arguments = new ATS(args);
        arguments.parse();
        Project projectData = Project.getProjectData(arguments.getProjectFolder(), arguments.getDestinationFolder(), arguments.getReportFolder());
        if (projectData.isValidated()) {
            Generator generator = new Generator(projectData);
            GeneratorReport report = generator.launch();
            ATS.logInfo(StringUtils.repeat((String)"-", (int)72));
            ATS.logInfo("ATS Generator finished :");
            ATS.logInfo("- java files generated -> " + report.getGeneratedScriptsCount());
            ATS.logInfo("- ellapsed time -> " + report.getGenerationEllapsedTime() + " ms");
            ATS.logInfo(StringUtils.repeat((String)"-", (int)72));
            if (arguments.isCompile()) {
                File tempXml = AntCompiler.createXmlFile(projectData.getTargetFolderPath().toString());
                AntCompiler.build(tempXml);
            }
        } else {
            ATS.logInfo("no valid Ats project found at -> " + String.valueOf(arguments.getProjectFolder()));
        }
    }

    public static String findSuiteFile(String s) {
        if (Paths.get((String)s, new String[0]).toFile().exists()) {
            return s;
        }
        if (Paths.get((String)s + ".xml", new String[0]).toFile().exists()) {
            return (String)s + ".xml";
        }
        if (Paths.get((String)(s = "src/exec/" + (String)s), new String[0]).toFile().exists()) {
            return s;
        }
        if (Paths.get((String)s + ".xml", new String[0]).toFile().exists()) {
            return (String)s + ".xml";
        }
        return null;
    }

    public Generator(String projectPath) {
        this(new File(projectPath));
    }

    public Generator(File atsFile) {
        this(Project.getProjectData(atsFile, null, null));
    }

    public Generator(Project project) {
        if (this.init(project) && this.remainingScripts > 0) {
            project.initFolders();
            this.genReport.startGenerator(this.remainingScripts);
            this.lexer = new Lexer(project, this.genReport, StandardCharsets.UTF_8);
        } else {
            ATS.logInfo("nothing to be done (no ATS files found !)");
        }
    }

    private boolean init(Project p) {
        if (p.isValidated()) {
            this.genReport = new GeneratorReport();
            this.project = p;
            this.filesList = this.project.getAtsScripts();
            this.remainingScripts = this.filesList.size();
            return true;
        }
        return false;
    }

    public GeneratorReport launch() {
        if (Files.exists(this.project.getJavaSourceFolder(), new LinkOption[0])) {
            Utils.copyFiles(this.project.getJavaSourceFolder().toString(), this.project.getJavaDestinationFolder().toString(), true);
        }
        try (Stream stream = this.filesList.parallelStream();){
            stream.forEach(this::generateJava);
        }
        this.genReport.endGenerator();
        this.filesList = null;
        this.lexer = null;
        return this.genReport;
    }

    private void generateJava(Path p) {
        AtsScript sc = this.lexer.loadScript(p.toFile(), new ScriptProcessedNotifier(this));
        if (sc != null) {
            sc.generateJavaFile(this.project);
        } else {
            System.out.println("error generating java code: " + p.toString());
        }
    }

    public ArrayList<AtsScript> getScripts() {
        ArrayList<AtsScript> result = new ArrayList<AtsScript>();
        for (Path p : this.filesList) {
            result.add(this.lexer.loadScript(p.toFile(), new ScriptProcessedNotifier(this)));
        }
        return result;
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public void scriptProcessed() {
        --this.remainingScripts;
    }

    public static class NoWarningOutputStream
    extends FilterOutputStream {
        private String output = "";

        public NoWarningOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String data = new String(b, off, len);
            this.output = this.output + data;
            if (data.contains("\n")) {
                if (!this.output.contains("WARNING:")) {
                    super.write(this.output.getBytes(), 0, this.output.length());
                }
                this.output = "";
            }
        }
    }
}

