/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import com.ats.executor.ActionTestScript;
import com.ats.executor.SendKeyData;
import com.ats.generator.variables.CalculatedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KeyParser {
    private static final Pattern pattern = Pattern.compile("\\$key\\s*\\(\\s*([A-Z_-]+)\\s*(?:,\\s*(\\d+)\\s*)?\\)");

    private KeyParser() {
    }

    public static ArrayList<SendKeyData> parse(ActionTestScript script, boolean oneChar, CalculatedValue calc) {
        String input = calc.getCalculated();
        Matcher matcher = pattern.matcher(input);
        ArrayList<SendKeyData> list = new ArrayList<SendKeyData>();
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                KeyParser.addText(list, oneChar, calc.uncrypt(script, input.substring(lastEnd, matcher.start())));
            }
            String key = matcher.group(1);
            String cStr = matcher.group(2);
            Integer count = cStr != null ? Integer.valueOf(cStr) : 1;
            KeyParser.addKey(list, key, count);
            lastEnd = matcher.end();
        }
        if (lastEnd < input.length()) {
            KeyParser.addText(list, oneChar, calc.uncrypt(script, input.substring(lastEnd)));
        }
        return list;
    }

    private static void addText(List<SendKeyData> list, boolean oneChar, String text) {
        if (!text.isEmpty()) {
            if (oneChar) {
                for (int i = 0; i < text.length(); ++i) {
                    list.add(new SendKeyData(String.valueOf(text.charAt(i))));
                }
            } else {
                list.add(new SendKeyData(text));
            }
        }
    }

    private static void addKey(List<SendKeyData> list, String key, int count) {
        String spare = key;
        if (key.startsWith("CONTROL")) {
            key = "CONTROL";
            spare = spare.replace("CONTROL", "").replace("-", "").replace("SHIFT", "").replace("ALT", "");
        } else if (key.startsWith("SHIFT")) {
            key = "SHIFT";
            spare = spare.replace("SHIFT", "").replace("-", "").replace("CONTROL", "").replace("ALT", "");
        } else if (key.startsWith("ALT")) {
            key = "ALT";
            spare = spare.replace("ALT", "").replace("-", "").replace("CONTROL", "").replace("SHIFT", "");
        } else {
            spare = "";
        }
        for (int i = 0; i < count; ++i) {
            list.add(new SendKeyData(key, spare));
        }
    }
}

