/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script;

import com.ats.AtsSingleton;
import com.ats.generator.GeneratorReport;
import com.ats.generator.parsers.Lexer;
import com.ats.script.AtsScript;
import com.ats.script.ProjectUser;
import com.ats.script.Script;
import com.ats.tools.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Project {
    private static final DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    public static final String TARGET_FOLDER = "target";
    public static final String LOGS_FOLDER = "logs";
    private static final String TARGET_FOLDER_REPORT = "report";
    public static final String TARGET_FOLDER_GENERATED = "generated";
    public static final String TARGET_FOLDER_CLASSES = "classes";
    public static final String SRC_FOLDER = "src";
    public static final String ASSETS_FOLDER = "assets";
    public static final String DATA_FOLDER = "data";
    public static final String SECRET_FOLDER = "secret";
    public static final String SECRET_FILE = "pdata";
    public static final String EXEC_FOLDER = "exec";
    public static final String CERTS_FOLDER = "certs";
    public static final String RESOURCES_FOLDER = "resources";
    public static final String IMAGES_FOLDER = "images";
    private static final String REPORTS_FOLDER = "reports";
    private static final String REPORT_LOGO = "logo.png";
    private static final String REPORT_WATERMARK = "watermark.png";
    public static final String REPORT_LOGO_URL = "assets" + "/" + "resources" + "/" + "reports" + "/" + "images" + "/" + "logo.png";
    public static final String REPORT_WATERMARK_URL = "assets" + "/" + "resources" + "/" + "reports" + "/" + "images" + "/" + "watermark.png";
    public static final String SECRET_FILE_URL = "assets" + "/" + "secret" + "/" + "pdata";
    public static final String SECRET_FOLDER_URL = "assets" + "/" + "secret";
    private static final String SRC_FOLDER_MAIN = "main";
    private static final String SRC_FOLDER_ATS = "ats";
    private static final String SRC_FOLDER_JAVA = "java";
    private static final String SRC_FOLDER_JAVASCRIPT = "javascript";
    private static final String SRC_FOLDER_PYTHON = "python";
    private static final String SRC_FOLDER_CSHARP = "cs";
    private static final String ATS_PROPERTIES_FILE = ".atsProjectProperties";
    private static final Pattern GROUP_PATTERN = Pattern.compile("groups.*->(.*)", 2);
    private String name = "";
    private String domain = "";
    private String description = "";
    private String version = "";
    private String folderPath = "";
    private boolean useProjectDomain = false;
    private String atsKey = null;
    private String uuid = "";
    private String logsType = "";
    private String scriptPrefix = "Tc";
    private File folder;
    private Path javaDestinationFolderPath;
    private Path reportDestinationFolderPath;
    private HashMap<String, String> variables = new HashMap();
    private ProjectUser[] users;
    private HashMap<String, NamedNodeMap> groups = new HashMap();
    private List<AtsScript> _scripts;

    public static Project getProjectData(File sourceFolder, File destinationFolder, File reportFolder) {
        File xmlDataFile = Project.checkAtsProjectFolder(sourceFolder);
        if (xmlDataFile != null) {
            return new Project(xmlDataFile, destinationFolder, reportFolder);
        }
        StringBuilder xmlContent = new StringBuilder();
        try {
            ClassLoader.getSystemClassLoader();
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(ATS_PROPERTIES_FILE);
            if (inputStream != null) {
                String line;
                InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                BufferedReader in = new BufferedReader(streamReader);
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("<?xml")) continue;
                    xmlContent.append(line.replace("\t", ""));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!xmlContent.isEmpty()) {
            return new Project(sourceFolder, xmlContent.toString());
        }
        return new Project(sourceFolder);
    }

    public static byte[] getSecretFileContent() throws IOException {
        InputStream input = Project.class.getClassLoader().getResourceAsStream(SECRET_FILE_URL);
        if (input == null) {
            input = Project.class.getClassLoader().getResourceAsStream("src/" + SECRET_FILE_URL);
        }
        if (input != null) {
            return input.readAllBytes();
        }
        return null;
    }

    public static List<Path> getSecretFolderListFiles(ClassLoader cl) throws IOException, URISyntaxException {
        Path p;
        URL url;
        List<Path> result = new ArrayList<Path>();
        Enumeration<URL> urls = cl.getResources(SECRET_FOLDER_URL);
        while (urls.hasMoreElements()) {
            url = urls.nextElement();
            if (!url.toString().endsWith(".atsc")) continue;
            result.add(Paths.get(url.toURI()));
        }
        if (result.isEmpty() && Files.exists(p = Paths.get((url = cl.getResource(SECRET_FOLDER_URL)).toURI()), new LinkOption[0]) && Files.isDirectory(p, new LinkOption[0])) {
            result = Project.listByExtension(p, "atsc");
        }
        return result;
    }

    public static List<Path> listByExtension(Path dir, String extension) throws IOException {
        Objects.requireNonNull(dir, "dir");
        Objects.requireNonNull(extension, "extension");
        String ext = "." + extension.toLowerCase(Locale.ROOT);
        try (Stream<Path> s = Files.list(dir);){
            List<Path> list = s.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(ext)).sorted(Comparator.comparing(p -> p.getFileName().toString().toLowerCase(Locale.ROOT))).toList();
            return list;
        }
    }

    public static String getAssetsJavaCode(String path) {
        StringBuilder pathBuilder = new StringBuilder("emb").append("(\"").append(ASSETS_FOLDER).append("/").append(path).append("\")");
        return pathBuilder.toString();
    }

    public static String getAssetsImageJavaCode(String path) {
        StringBuilder pathBuilder = new StringBuilder(RESOURCES_FOLDER);
        pathBuilder.append("/").append(IMAGES_FOLDER).append("/").append(path);
        return Project.getAssetsJavaCode(pathBuilder.toString());
    }

    private static File checkAtsProjectFolder(File f) {
        if (f != null) {
            File xmlPropertiesFile = f.toPath().resolve(ATS_PROPERTIES_FILE).toFile();
            if (xmlPropertiesFile.exists()) {
                return xmlPropertiesFile;
            }
            return Project.checkAtsProjectFolder(f.getParentFile());
        }
        return null;
    }

    public Project() {
    }

    public Project(File f) {
        if (f.exists()) {
            if (f.isDirectory()) {
                this.folder = f;
            } else if (f.isFile()) {
                this.folder = f.getParentFile();
            }
            this.folderPath = this.folder.getPath();
            this.setJavaDestinationFolderPath(this.getTargetFolderPath().resolve(TARGET_FOLDER_GENERATED));
            this.setReportDestinationFolderPath(this.getTargetFolderPath().resolve(TARGET_FOLDER_REPORT));
        }
    }

    public Project(File f, String xmlContent) {
        this(f);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlContent)));
            this.addVariables(doc.getElementsByTagName("variable"));
            this.addUsers(doc.getElementsByTagName("user"));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        AtsSingleton.getInstance().setProjectVariables(this.getVariables());
    }

    public Project(File xmlPropertiesFile, File generatedJavaFolder, File reportFolder) {
        this.folder = xmlPropertiesFile.getParentFile();
        this.folderPath = xmlPropertiesFile.getParent();
        this.parseXmlFile(xmlPropertiesFile);
        if (generatedJavaFolder != null) {
            this.setJavaDestinationFolderPath(generatedJavaFolder.toPath());
        } else {
            this.setJavaDestinationFolderPath(this.getTargetFolderPath().resolve(TARGET_FOLDER_GENERATED));
        }
        if (reportFolder != null) {
            this.setReportDestinationFolderPath(reportFolder.toPath());
        } else {
            this.setReportDestinationFolderPath(this.getTargetFolderPath().resolve(TARGET_FOLDER_REPORT));
        }
        AtsSingleton.getInstance().setProjectVariables(this.getVariables());
    }

    public boolean isValidated() {
        return this.folder != null;
    }

    private void setJavaDestinationFolderPath(Path p) {
        this.javaDestinationFolderPath = p;
        this.javaDestinationFolderPath.toFile().mkdirs();
    }

    public String getDomainPath() {
        if (this.useProjectDomain) {
            return this.getDomainPackage().replace(".", "/");
        }
        return "";
    }

    public String getDomainPackage() {
        if (this.useProjectDomain) {
            return this.domain + "." + this.name;
        }
        return this.name;
    }

    private void setReportDestinationFolderPath(Path p) {
        this.reportDestinationFolderPath = p;
        this.reportDestinationFolderPath.toFile().mkdirs();
    }

    public void synchronize() {
        this.folder = new File(this.folderPath);
        Path targetFolderPath = this.getTargetFolderPath();
        this.setJavaDestinationFolderPath(targetFolderPath.resolve(TARGET_FOLDER_GENERATED));
        this.setReportDestinationFolderPath(targetFolderPath.resolve(TARGET_FOLDER_REPORT));
    }

    public void initFolders() {
        File javaFolder = this.javaDestinationFolderPath.toFile();
        try {
            Utils.deleteRecursiveJavaFiles(javaFolder);
            javaFolder.mkdirs();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void parseXmlFile(File xmlPropertiesFile) {
        try {
            DocumentBuilder dBuilder = docFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlPropertiesFile);
            Node xmlNode = doc.getElementsByTagName("domain").item(0);
            if (xmlNode != null) {
                this.setDomain(xmlNode.getTextContent());
            }
            if ((xmlNode = doc.getElementsByTagName("name").item(0)) != null) {
                this.setName(xmlNode.getTextContent());
            }
            if ((xmlNode = doc.getElementsByTagName("description").item(0)) != null) {
                this.setDescription(xmlNode.getTextContent());
            }
            if ((xmlNode = doc.getElementsByTagName("version").item(0)) != null) {
                this.setVersion(xmlNode.getTextContent());
            }
            if ((xmlNode = doc.getElementsByTagName("atsKey").item(0)) != null) {
                this.atsKey = xmlNode.getTextContent();
            }
            if ((xmlNode = doc.getElementsByTagName("useProjectDomain").item(0)) != null) {
                this.setUseProjectDomain("true".equalsIgnoreCase(xmlNode.getTextContent()));
            }
            if ((xmlNode = doc.getElementsByTagName("uuid").item(0)) != null) {
                this.setUuid(xmlNode.getTextContent());
            }
            if ((xmlNode = doc.getElementsByTagName("scriptPrefix").item(0)) != null) {
                this.setScriptPrefix(xmlNode.getTextContent());
            }
            if ((xmlNode = doc.getElementsByTagName("logsType").item(0)) != null) {
                this.setLogsType(xmlNode.getTextContent());
            }
            this.addGroups(doc.getElementsByTagName("group"));
            this.addVariables(doc.getElementsByTagName("variable"));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            System.err.println(e.getMessage());
        }
    }

    private void addVariables(NodeList varList) {
        for (int i = 0; i < varList.getLength(); ++i) {
            Node nodeVar = varList.item(i);
            this.variables.put(nodeVar.getAttributes().getNamedItem("name").getNodeValue(), nodeVar.getTextContent());
        }
    }

    public HashMap<String, String> getVariables() {
        return this.variables;
    }

    private void addUsers(NodeList usersList) {
        int len = usersList.getLength();
        this.users = new ProjectUser[len];
        for (int i = 0; i < len; ++i) {
            Node nodeVar = usersList.item(i);
            this.users[i] = new ProjectUser(nodeVar.getAttributes().getNamedItem("name").getNodeValue(), nodeVar.getAttributes().getNamedItem("systemUser").getNodeValue(), nodeVar.getAttributes().getNamedItem("email").getNodeValue(), nodeVar.getAttributes().getNamedItem("pic").getNodeValue());
        }
    }

    public byte[] getUserPicString(String value) {
        for (int i = 0; i < this.users.length; ++i) {
            byte[] pic = this.users[i].getPic(value);
            if (pic == null) continue;
            return pic;
        }
        return null;
    }

    private void addGroups(NodeList groupsList) {
        for (int i = 0; i < groupsList.getLength(); ++i) {
            Node nodeGroup = groupsList.item(i);
            this.groups.put(nodeGroup.getTextContent(), nodeGroup.getAttributes());
        }
    }

    public HashMap<String, NamedNodeMap> getGroups() {
        return this.groups;
    }

    public Path getTargetFolderPath() {
        return this.folder.toPath().resolve(TARGET_FOLDER);
    }

    public Path getAssetsFolderPath() {
        return this.getSourceFolderPath().resolve(ASSETS_FOLDER);
    }

    private Path getSourceFolderPath() {
        return this.folder.toPath().resolve(SRC_FOLDER);
    }

    private Path getSourceMainFolderPath() {
        return this.getSourceFolderPath().resolve(SRC_FOLDER_MAIN);
    }

    public Path getAtsSourceFolder() {
        return this.getSourceMainFolderPath().resolve(SRC_FOLDER_ATS);
    }

    public Path getJavaSourceFolder() {
        return this.getSourceMainFolderPath().resolve(SRC_FOLDER_JAVA);
    }

    public Path getJavascriptSourceFolder() {
        return this.getSourceMainFolderPath().resolve(SRC_FOLDER_JAVASCRIPT);
    }

    public Path getPythonSourceFolder() {
        return this.getSourceMainFolderPath().resolve(SRC_FOLDER_PYTHON);
    }

    public Path getCSharpSourceFolder() {
        return this.getSourceMainFolderPath().resolve(SRC_FOLDER_CSHARP);
    }

    public Path getDataSourceFolder() {
        return this.getAssetsFolderPath().resolve(DATA_FOLDER);
    }

    public Path getSuiteSourceFolder() {
        return this.getSourceFolderPath().resolve(EXEC_FOLDER);
    }

    public Path getJavaDestinationFolder() {
        return this.javaDestinationFolderPath;
    }

    public Path getReportFolder() {
        return this.reportDestinationFolderPath;
    }

    public File getJavaFile(String qualifiedPath) {
        return this.getJavaDestinationFolder().resolve(qualifiedPath).toFile();
    }

    public String getGav() {
        return this.domain + "." + this.name + "(" + this.version + ")";
    }

    public String getGroupsJson(List<String> list) {
        if (list != null && !list.isEmpty()) {
            JsonArray jsonList = new JsonArray(list.size());
            for (String group : list) {
                JsonObject jsonGroup = new JsonObject();
                jsonGroup.addProperty("name", group);
                NamedNodeMap map = this.groups.get(group);
                int len = map.getLength();
                for (int i = 0; i < len; ++i) {
                    Node node = map.item(i);
                    jsonGroup.addProperty(node.getNodeName(), node.getNodeValue());
                }
                jsonList.add((JsonElement)jsonGroup);
            }
            return StringEscapeUtils.escapeJson((String)jsonList.toString());
        }
        return "";
    }

    public List<Path> getAtsScripts() {
        return Utils.listFilesWithExtension(this.getAtsSourceFolder(), ".ats");
    }

    public List<AtsScript> getAtsScripts(Lexer lexer) {
        List<Path> paths = Utils.listFilesWithExtension(this.getAtsSourceFolder(), ".ats");
        return paths.parallelStream().map(p -> new AtsScript(lexer, (Path)p)).toList();
    }

    public List<AtsScript> getAtsScriptsByGroup(String groupName) {
        ArrayList<AtsScript> scripts = new ArrayList<AtsScript>();
        this.getAtsScripts().forEach(p -> this.checkGroups(p.toFile(), groupName, scripts));
        return scripts;
    }

    private void checkGroups(File f, String groupName, ArrayList<AtsScript> scripts) {
        block3: {
            try {
                String[] groups;
                String content = Files.readString(f.toPath(), StandardCharsets.UTF_8);
                Matcher m = GROUP_PATTERN.matcher(content);
                if (!m.find() || m.groupCount() <= 0) break block3;
                for (String group : groups = m.group(1).split(",")) {
                    if (!group.contains(groupName)) continue;
                    scripts.add(new AtsScript(this, f));
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public AtsScript[] loadScriptsInfo() {
        Lexer lexer = new Lexer(this, new GeneratorReport(), Script.DEFAULT_CHARSET);
        List<Path> paths = Utils.listFilesWithExtension(this.getAtsSourceFolder(), ".ats");
        try (Stream stream = paths.parallelStream();){
            AtsScript[] atsScriptArray = (AtsScript[])stream.map(p -> new AtsScript(lexer, (Path)p)).toArray(AtsScript[]::new);
            return atsScriptArray;
        }
    }

    public static Document getProjectProperties() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(ATS_PROPERTIES_FILE);
        if (input != null) {
            return dBuilder.parse(input);
        }
        Path projectProperties = Paths.get(ATS_PROPERTIES_FILE, new String[0]);
        if (Files.exists(projectProperties, new LinkOption[0])) {
            return dBuilder.parse(projectProperties.toFile());
        }
        return null;
    }

    public static String getProjectFolderPath() {
        Path projectProperties = Paths.get(ATS_PROPERTIES_FILE, new String[0]);
        if (Files.exists(projectProperties, new LinkOption[0])) {
            return projectProperties.toAbsolutePath().getParent().toString();
        }
        return "";
    }

    public static Path getProjectTargetFolderPath() {
        Path projectProperties = Paths.get(ATS_PROPERTIES_FILE, new String[0]);
        if (Files.exists(projectProperties, new LinkOption[0])) {
            return projectProperties.resolve(TARGET_FOLDER).toAbsolutePath().getParent();
        }
        return Paths.get("", new String[0]).resolve(TARGET_FOLDER);
    }

    public void loadScripts(Lexer lexer) {
        this._scripts = this.getAtsScripts(lexer);
    }

    public List<AtsScript> getScripts() {
        return this._scripts;
    }

    public void setScripts(List<AtsScript> list) {
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String value) {
        this.domain = value;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String value) {
        this.uuid = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String value) {
        this.folderPath = value;
    }

    public boolean isUseProjectDomain() {
        return this.useProjectDomain;
    }

    public void setUseProjectDomain(boolean useProjectDomain) {
        this.useProjectDomain = useProjectDomain;
    }

    public String getAtsKey() {
        return this.atsKey;
    }

    public String getLogsType() {
        return this.logsType;
    }

    public void setLogsType(String value) {
        this.logsType = value;
    }

    public String getScriptPrefix() {
        return this.scriptPrefix;
    }

    public void setScriptPrefix(String scriptPrefix) {
        this.scriptPrefix = scriptPrefix;
    }

    public static final class DirectoryBeforeFileComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            if (o1.isDirectory() && !o2.isDirectory()) {
                return 1;
            }
            if (!o1.isDirectory() && o2.isDirectory()) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }
}

