/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.logger.levels;

import com.ats.script.actions.Action;
import com.ats.tools.logger.NullPrintStream;
import com.ats.tools.logger.prefix.AzureDevOps;
import com.ats.tools.logger.prefix.ILogType;
import com.ats.tools.logger.prefix.Terminal;
import com.ats.tools.logger.prefix.TerminalColor;
import java.io.PrintStream;
import java.nio.file.Path;

public class AtsLogger {
    public static final String TYPE_TERM = "term";
    public static final String TYPE_AZD = "azd";
    protected ILogType logType = new TerminalColor();
    private PrintStream out;
    private static volatile AtsLogger instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtsLogger getInstance() {
        Class<AtsLogger> clazz = AtsLogger.class;
        synchronized (AtsLogger.class) {
            if (instance == null) {
                instance = new AtsLogger();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void printLog(String ... values) {
        AtsLogger.printLog(String.join((CharSequence)" -> ", values));
    }

    public static void printWarning(String info, String value) {
        StringBuilder sb = new StringBuilder(info).append(" -> ").append(value);
        AtsLogger.getInstance().printWarning(sb.toString());
    }

    public static void printLog(StringBuilder value) {
        AtsLogger.printLog(value.toString());
    }

    public static void printLog(String value) {
        AtsLogger.getInstance().printScript(value);
    }

    public AtsLogger() {
        this.out = new NullPrintStream();
    }

    public AtsLogger(PrintStream out, String type, String level, Path outputFolder) {
        instance = this;
        StringBuilder sb = null;
        this.out = out;
        sb = new StringBuilder(this.logType.getLoggerData());
        if (TYPE_TERM.equals(type)) {
            this.logType = new TerminalColor();
            sb.append("[Terminal Color] ");
        } else if (TYPE_AZD.equals(type)) {
            this.logType = new AzureDevOps();
            sb.append("[Azure DevOps] ");
        } else {
            this.logType = new Terminal();
        }
        sb.append("logger level").append(" -> ").append(level);
        out.println(sb.toString());
    }

    protected void printOutput(String value) {
        this.out.println(this.logType.getDriverOutput() + value);
    }

    protected void printError(String info, String value) {
        this.out.println(this.logType.getErrorData() + info + " -> " + value);
    }

    protected void printInfo(String value) {
        this.out.println(this.logType.getInfoData() + value);
    }

    protected void printWarning(String value) {
        this.out.println(this.logType.getWarningData() + value);
    }

    public void suiteOutput(String value) {
        this.out.println(this.logType.getSuiteData() + value);
    }

    public void testOutput(String value) {
        this.out.println(this.logType.getTestData(value) + value);
    }

    public void printFail(String actionName, String testName, int line, String info, String details) {
        this.out.println(this.logType.getFailData(actionName, testName, line, info, details));
    }

    public void printScript(String value) {
        this.out.println(this.logType.getScriptData(value) + value);
    }

    public void printAction(String value) {
        this.out.println(this.logType.getActionData() + value);
    }

    public void comment(String message) {
        this.out.println(this.logType.getCommentData(message));
    }

    public void driverLog(String value) {
        this.out.println(this.logType.getDriverLog() + value);
    }

    public void driverWarning(String value) {
        this.out.println(this.logType.getDriverWarning() + value);
    }

    public void driverError(String value) {
        this.out.println(this.logType.getDriverError() + value);
    }

    public void driverOutput(String value) {
    }

    public void warning(String message) {
    }

    public void info(String message) {
    }

    public void error(String info, String value) {
    }

    public void action(Action action, String testName, int line) {
    }
}

