/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.adapters;

import com.ats.tools.report.Constants;
import com.ats.tools.report.adapters.ReportAdapter;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Results;
import com.ats.tools.report.models.Script;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.SuiteInfo;
import com.ats.tools.report.models.TestSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FailPassFilterReportAdapter
implements ReportAdapter {
    private static final int SUMMARY_FAIL = Integer.parseInt(Constants.SummaryStatus.FAIL.getNumericValue());
    private static final int SUMMARY_PASS = Integer.parseInt(Constants.SummaryStatus.PASS.getNumericValue());
    private final boolean filterPass;
    private final Predicate<Integer> summaryStatusPredicate;
    private final String suiteStatus;

    public FailPassFilterReportAdapter(boolean filterPass) {
        this.filterPass = filterPass;
        this.summaryStatusPredicate = filterPass ? status -> status >= SUMMARY_PASS : status -> SUMMARY_FAIL == status;
        this.suiteStatus = filterPass ? Constants.Status.PASS.getValue() : Constants.Status.FAIL.getValue();
    }

    @Override
    public void apply(HtmlReportProject project, Results results, List<TestSummary> testSummaries, List<Script> scripts) {
        this.filterScripts(scripts);
        this.filterTestSummaries(testSummaries);
        Map<String, List<TestSummary>> testSummariesBySuites = testSummaries.stream().collect(Collectors.groupingBy(TestSummary::getSuiteName));
        this.filterResults(results, testSummariesBySuites);
        this.filterSuitesInProject(project, testSummariesBySuites);
    }

    private void filterScripts(List<Script> scripts) {
        for (int i = scripts.size() - 1; i >= 0; --i) {
            if (scripts.get(i).isPassed() == this.filterPass) continue;
            scripts.remove(i);
        }
    }

    private void filterTestSummaries(List<TestSummary> testSummaries) {
        for (int i = testSummaries.size() - 1; i >= 0; --i) {
            if (this.summaryStatusPredicate.test(Integer.parseInt(testSummaries.get(i).getStatus()))) continue;
            testSummaries.remove(i);
        }
    }

    private void filterResults(Results results, Map<String, List<TestSummary>> testSummariesBySuites) {
        List<SuiteInfo> suites = results.getSuites();
        for (int i = suites.size() - 1; i >= 0; --i) {
            SuiteInfo suiteInfo = suites.get(i);
            if (!testSummariesBySuites.containsKey(suiteInfo.getName())) {
                suites.remove(i);
                continue;
            }
            List<TestSummary> suiteTests = testSummariesBySuites.get(suiteInfo.getName());
            if (this.filterPass) {
                suiteInfo.setTestsPassed(suiteTests.size());
                suiteInfo.setTestsFailed(0);
            } else {
                suiteInfo.setTestsPassed(0);
                suiteInfo.setTestsFailed(suiteTests.size());
            }
            long duration = suiteTests.stream().mapToLong(testSummary -> Optional.ofNullable(testSummary.getDuration()).filter(StringUtils::isNotBlank).map(Long::parseLong).orElse(0L)).sum();
            suiteInfo.setDuration(duration);
            suiteInfo.setStatus(this.suiteStatus);
            suiteInfo.setTestsFiltered(0);
        }
        if (this.filterPass) {
            results.setSuitesPassed(suites.size());
            results.setSuitesFailed(0);
        } else {
            results.setSuitesPassed(0);
            results.setSuitesFailed(suites.size());
        }
        results.setSuitesCount(suites.size());
        results.setTestsCount(testSummariesBySuites.values().stream().mapToInt(List::size).sum());
        results.setStatus(this.suiteStatus);
        results.setDuration(suites.stream().mapToLong(SuiteInfo::getDuration).sum());
    }

    private void filterSuitesInProject(HtmlReportProject project, Map<String, List<TestSummary>> testSummariesBySuites) {
        List<Suite> suites = project.getSuites();
        for (int i = suites.size() - 1; i >= 0; --i) {
            Suite suite = suites.get(i);
            if (!testSummariesBySuites.containsKey(suite.getName())) {
                suites.remove(i);
                continue;
            }
            List<TestSummary> suiteTests = testSummariesBySuites.get(suite.getName());
            suite.setTests(suiteTests.stream().map(TestSummary::getTestName).toList());
            if (!CollectionUtils.isNotEmpty(suite.getIncludedGroups())) continue;
            suite.setIncludedGroups(new ArrayList<String>(suiteTests.stream().flatMap(testSummary -> testSummary.getGroups().stream()).collect(Collectors.toSet())));
        }
    }
}

