/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.generators;

import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.context.reader.FailPassReportContextExecutionAware;
import com.ats.tools.report.context.reader.ReportContextExecutionReader;
import com.ats.tools.report.generators.HtmlMainReportGenerator;
import com.ats.tools.report.generators.HtmlSummaryReportGenerator;
import com.ats.tools.report.generators.XmlReportGenerator;
import com.ats.tools.report.models.ReportContextExecution;
import com.ctc.wstx.stax.WstxInputFactory;
import org.apache.commons.collections4.CollectionUtils;

public class CampaignReportGenerator {
    private final ReportContextExecution contextExecution;
    private final ReportContextExecutionReader contextExecutionReader;

    public CampaignReportGenerator(ReportContextExecutionReader reader) throws Exception {
        System.getProperties().put("javax.xml.stream.XMLInputFactory", InputFactory.class.getName());
        this.contextExecutionReader = reader;
        this.contextExecution = reader.getReportContextExecution();
    }

    public void generateSuitsHtmlReports() throws Exception {
        this.generateXmlReport();
        this.generateMainReport();
        this.generateSummaryReport();
    }

    private void generateXmlReport() throws Exception {
        if (this.contextExecution.reportSettings().generateXmlReport()) {
            XmlReportGenerator xmlReportGenerator = new XmlReportGenerator(this.contextExecution);
            xmlReportGenerator.generateReport();
        } else {
            AtsLogger.printLog("XML report", "generation skipped");
        }
    }

    private void generateMainReport() throws Exception {
        HtmlMainReportGenerator reportGenerator = new HtmlMainReportGenerator(this.contextExecution);
        reportGenerator.generateReport();
        if (this.contextExecution.reportSettings().splitReport()) {
            FailPassReportContextExecutionAware failPassReader = (FailPassReportContextExecutionAware)((Object)this.contextExecutionReader);
            this.generateFailPassReport(failPassReader.getPassContextExecution());
            this.generateFailPassReport(failPassReader.getFailContextExecution());
        }
    }

    private void generateSummaryReport() throws Exception {
        if (!this.contextExecution.suiteItem().isNoSuiteLaunch()) {
            new HtmlSummaryReportGenerator(this.contextExecution).generateReport();
        }
    }

    private void generateFailPassReport(ReportContextExecution contextExecution) throws Exception {
        if (CollectionUtils.isNotEmpty(contextExecution.project().getSuites())) {
            HtmlMainReportGenerator reportGenerator = new HtmlMainReportGenerator(contextExecution);
            reportGenerator.generateReport();
        } else {
            AtsLogger.printLog("HTML main report skipped", contextExecution.reportFileNames().mainHtmlReport());
        }
    }

    public static class InputFactory
    extends WstxInputFactory {
        public InputFactory() {
            this.setProperty("com.ctc.wstx.maxAttributeSize", Integer.MAX_VALUE);
        }
    }
}

