/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.generators;

import com.ats.recorder.TestError;
import com.ats.script.actions.ActionApi;
import com.ats.script.actions.ActionCallscript;
import com.ats.script.actions.ActionComment;
import com.ats.script.actions.ActionDownload;
import com.ats.tools.ResourceContent;
import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.Constants;
import com.ats.tools.report.XmlReport;
import com.ats.tools.report.actions.HtmlReportAction;
import com.ats.tools.report.filters.ContentFilter;
import com.ats.tools.report.general.HtmlReport;
import com.ats.tools.report.general.HtmlReportExecution;
import com.ats.tools.report.general.HtmlReportPlaylist;
import com.ats.tools.report.general.HtmlReportTestInfo;
import com.ats.tools.report.generators.ReportGenerator;
import com.ats.tools.report.models.Action;
import com.ats.tools.report.models.ActionElement;
import com.ats.tools.report.models.AppDataJson;
import com.ats.tools.report.models.Bound;
import com.ats.tools.report.models.Channel;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Image;
import com.ats.tools.report.models.PlaylistData;
import com.ats.tools.report.models.ReportContextExecution;
import com.ats.tools.report.models.ReportDurationData;
import com.ats.tools.report.models.ReportSettings;
import com.ats.tools.report.models.ReportSummary;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.SuiteInfo;
import com.ats.tools.report.models.SuiteSummary;
import com.ats.tools.report.models.TestInfo;
import com.ats.tools.report.models.TestSummary;
import com.ats.tools.report.summary.ActionsCountCalculator;
import com.ats.tools.report.summary.DurationCalculator;
import com.ats.tools.report.summary.SummaryCalculator;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class HtmlMainReportGenerator
implements ReportGenerator {
    private static final String reportSuiteTemplate = ResourceContent.getHtmlReportSuiteTemplate();
    private static final String mainTemplate = ResourceContent.getHtmlReportTemplate();
    private static final String styles = ResourceContent.getHtmlReportCss();
    private static final String javascript = ResourceContent.getHtmlReportJavascript();
    private static final Set<String> DATA_JSON_ACTION_TYPES = Set.of(ActionCallscript.class.getSimpleName(), "EndOfRecording", ActionDownload.class.getSimpleName());
    private final ReportContextExecution contextExecution;
    private PlaylistData playlistsDataCurrent = null;
    private HtmlReportPlaylist htmlReportPlaylist;
    private final List<PlaylistData> playlistsDataLst = new ArrayList<PlaylistData>();
    private final DurationCalculator reportLevelDurationCalculator;
    private final Gson gson;
    private final SummaryCalculator summaryCalculator;

    public HtmlMainReportGenerator(ReportContextExecution contextExecution) {
        this.contextExecution = contextExecution;
        this.reportLevelDurationCalculator = new DurationCalculator(Duration.ofMillis(contextExecution.project().getReportSummary().techDuration()));
        this.gson = new Gson();
        this.summaryCalculator = new SummaryCalculator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateReport() throws Exception {
        HtmlReportExecution htmlReportExecution = new HtmlReportExecution(this.contextExecution);
        try {
            htmlReportExecution.processMainExecutionsFile();
            for (Suite suite : this.contextExecution.project().getSuites()) {
                this.generateHtmlSuite(suite, htmlReportExecution.getFileWriter(), htmlReportExecution.getValidationFileWriter());
            }
            this.updateCalculatedStepsCount();
            this.writeJsonData(htmlReportExecution);
            if (!this.contextExecution.reportSettings().splitReport()) {
                AtsLogger.printLog("HTML main report generated", htmlReportExecution.getReportFilePath());
            }
            if (this.contextExecution.reportSettings().validationReport()) {
                AtsLogger.printLog("HTML validation report generated", htmlReportExecution.getValidationReportFilePath());
            }
        }
        catch (Exception e) {
            AtsLogger.printLog("an error occurred during HTML main report processing");
        }
        finally {
            htmlReportExecution.closeWriter();
        }
    }

    private void generateHtmlSuite(Suite suite, OutputStream fileWriter, OutputStream validationFileWriter) throws Exception {
        this.playlistsDataCurrent = new PlaylistData(suite.getName());
        try {
            this.htmlReportPlaylist = new HtmlReportPlaylist(suite, fileWriter, validationFileWriter, this.contextExecution);
            this.htmlReportPlaylist.processPlaylistData();
            SuiteSummary suiteSummary = suite.getSuiteSummary();
            this.playlistsDataCurrent.addTest(suiteSummary.passedTestsCount(), suiteSummary.failedTestsCount(), suiteSummary.filteredTestsCount());
            for (TestSummary testSummary : suite.getSuiteInfo().getSummaries()) {
                this.generateHtmlTestCase(suite.getSuiteInfo(), testSummary);
            }
            this.playlistsDataLst.add(this.playlistsDataCurrent);
            this.htmlReportPlaylist.processPlaylistFooter();
        }
        catch (Exception e) {
            AtsLogger.printLog(String.format("an error occurred during HTML main report processing of %s suite", suite.getName()));
            AtsLogger.printLog(String.format("error: %s", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHtmlTestCase(SuiteInfo suite, TestSummary testSummary) throws Exception {
        ReportSettings reportSettings = this.contextExecution.reportSettings();
        ContentFilter contentFilter = this.contextExecution.contentFilter();
        String suiteName = suite.getName();
        String testName = testSummary.getTestName();
        Path targetPath = reportSettings.outputFolder().resolve(suiteName).resolve(testName + "_xml");
        if (!Files.exists(targetPath, new LinkOption[0])) {
            return;
        }
        HashMap<String, String> appIcons = new HashMap<String, String>();
        boolean creatingObject = false;
        Action action = new Action();
        AppDataJson appDataJson = new AppDataJson();
        ActionElement actionElement = new ActionElement();
        TestInfo testInfo = new TestInfo();
        testInfo.setTestName(testName);
        testInfo.getGroups().addAll(testSummary.getGroups());
        testInfo.setStarted(Long.toString(testSummary.getStarted()));
        try (XMLStreamReader reader = null;
             InputStream inputStream = Files.newInputStream(targetPath.resolve(XmlReport.REPORT_DATA_FILE), new OpenOption[0]);
             OutputStream testCaseReportOutputStream = reportSettings.concatenationRun() || reportSettings.splitReport() ? OutputStream.nullOutputStream() : Files.newOutputStream(targetPath.resolve("ats-test-report.html"), new OpenOption[0]);){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            reader = factory.createXMLStreamReader(inputStream);
            HtmlReport htmlReport = this.createReport();
            HtmlReportAction htmlReportAction = new HtmlReportAction();
            boolean isTestInfo = false;
            int actionReportLineNumber = 1;
            ActionsCountCalculator actionsCountCalculator = new ActionsCountCalculator();
            while (reader.hasNext()) {
                int event = reader.next();
                if (event == 7) continue;
                if (event == 1) {
                    if ("action".equals(reader.getLocalName())) {
                        isTestInfo = false;
                        action.setIndex(Integer.parseInt(reader.getAttributeValue(0)));
                        String type = reader.getAttributeValue(1).split("\\.")[reader.getAttributeValue(1).split("\\.").length - 1];
                        int asSuite = Constants.SummaryStatus.PASS_CONTINUE.getNumericValue().equals(testInfo.getSummary().getStatus()) ? 1 : 0;
                        if (asSuite != 0 && "ActionCallscript".equals(type)) {
                            type = "EndOfRecording";
                        }
                        action.setType(type);
                        creatingObject = true;
                    } else if (!creatingObject && "script".equals(reader.getLocalName())) {
                        creatingObject = true;
                        isTestInfo = true;
                    }
                    if (creatingObject) {
                        if (isTestInfo) {
                            switch (reader.getLocalName()) {
                                case "script": {
                                    testInfo.setExternalId(reader.getAttributeValue("", "externalId"));
                                    testInfo.setTestId(reader.getAttributeValue("", "testId"));
                                    testInfo.setOsInfo(reader.getAttributeValue("", "osInfo"));
                                    break;
                                }
                                case "description": {
                                    testInfo.setDescription(reader.getElementText());
                                    break;
                                }
                                case "author": {
                                    testInfo.setAuthor(reader.getElementText());
                                    break;
                                }
                                case "modifiedBy": {
                                    testInfo.setModifiedBy(reader.getElementText());
                                    break;
                                }
                                case "modifiedAt": {
                                    testInfo.setModifiedAt(reader.getElementText());
                                    break;
                                }
                                case "createdAt": {
                                    testInfo.setCreatedAt(reader.getElementText());
                                    break;
                                }
                                case "prerequisite": {
                                    testInfo.setPrerequisite(reader.getElementText());
                                    break;
                                }
                                case "startedFormated": {
                                    testInfo.setStartedFormatted(reader.getElementText());
                                    break;
                                }
                                case "quality": {
                                    testInfo.setQuality(reader.getElementText());
                                    break;
                                }
                                case "project": {
                                    HtmlReportProject project = new HtmlReportProject();
                                    testInfo.setProject(project);
                                    break;
                                }
                                case "id": {
                                    testInfo.getProject().setProjectId(reader.getElementText());
                                    break;
                                }
                                case "name": {
                                    testInfo.getProject().setProjectName(reader.getElementText());
                                    break;
                                }
                                case "summary": {
                                    testInfo.setSummary(testSummary);
                                    break;
                                }
                                case "errors": {
                                    testInfo.getSummary().setTestErrors(new ArrayList<TestError>());
                                    break;
                                }
                                case "error": {
                                    TestError error = new TestError();
                                    error.setLine(Integer.parseInt(reader.getAttributeValue("", "line")));
                                    error.setScript(reader.getAttributeValue("", "script"));
                                    error.setTestErrorStatus(TestError.TestErrorStatus.valueOf(reader.getAttributeValue("", "testErrorStatus")));
                                    error.setMessage(Utils.escapeHTML(reader.getElementText()));
                                    testInfo.getSummary().getTestErrors().add(error);
                                    break;
                                }
                                case "data": {
                                    testInfo.getSummary().setData(reader.getElementText());
                                }
                            }
                        }
                        if (!isTestInfo) {
                            block65 : switch (reader.getLocalName()) {
                                case "line": {
                                    action.setLine(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "script": {
                                    action.setScript(reader.getElementText());
                                    break;
                                }
                                case "timeLine": {
                                    action.setTimeLine(Long.parseLong(reader.getElementText()));
                                    break;
                                }
                                case "error": {
                                    action.setError(reader.getElementText());
                                    break;
                                }
                                case "stop": {
                                    action.setStop(Boolean.parseBoolean(reader.getElementText()));
                                    break;
                                }
                                case "duration": {
                                    action.setDuration(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "passed": {
                                    action.setPassed(Boolean.parseBoolean(reader.getElementText()));
                                    break;
                                }
                                case "value": {
                                    action.setValue(reader.getElementText());
                                    break;
                                }
                                case "data": {
                                    if (isTestInfo) {
                                        testInfo.getSummary().setData(reader.getElementText());
                                        break;
                                    }
                                    String data = DATA_JSON_ACTION_TYPES.contains(action.getType()) ? reader.getElementText() : Utils.escapeHTML(reader.getElementText());
                                    action.setData(data);
                                    break;
                                }
                                case "parameter": {
                                    if (ActionApi.class.getSimpleName().equals(action.getType())) {
                                        switch (reader.getAttributeCount()) {
                                            case 2: {
                                                appDataJson.getData().put(reader.getAttributeValue(0), Utils.escapeHTML(reader.getAttributeValue(1)));
                                                break block65;
                                            }
                                            case 3: {
                                                appDataJson.getData().put(reader.getAttributeValue(0), Utils.escapeHTML(reader.getAttributeValue(2)));
                                                break block65;
                                            }
                                        }
                                        appDataJson.getData().put(reader.getAttributeValue(0), "\u00d8");
                                        break;
                                    }
                                    switch (reader.getAttributeValue(0)) {
                                        case "name": {
                                            appDataJson.setName(reader.getAttributeValue(1));
                                            action.setAppDataJson(appDataJson);
                                            break;
                                        }
                                        case "app": {
                                            appDataJson.setApp(reader.getAttributeValue(1));
                                            break;
                                        }
                                        case "appVersion": {
                                            appDataJson.setAppVersion(reader.getAttributeValue(1));
                                            break;
                                        }
                                        case "os": {
                                            appDataJson.setOs(reader.getAttributeValue(1));
                                            break;
                                        }
                                        case "appIcon": {
                                            appDataJson.setAppIcon(reader.getAttributeValue(1));
                                            appIcons.put(appDataJson.getApp(), appDataJson.getAppIcon());
                                        }
                                    }
                                    break;
                                }
                                case "img": {
                                    if (reader.getAttributeCount() <= 0) break;
                                    Image image = new Image(reader);
                                    if (image.getType().equals("api")) {
                                        image.useApiIcon();
                                    }
                                    action.setImage(image);
                                    break;
                                }
                                case "channel": {
                                    Channel channel = new Channel();
                                    channel.setName(reader.getAttributeValue(0));
                                    action.setChannel(channel);
                                    break;
                                }
                                case "bound": {
                                    Bound bound = new Bound();
                                    action.getChannel().setBound(bound);
                                    break;
                                }
                                case "x": {
                                    action.getChannel().getBound().setX(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "y": {
                                    action.getChannel().getBound().setY(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "width": {
                                    action.getChannel().getBound().setWidth(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "height": {
                                    action.getChannel().getBound().setHeight(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "element": {
                                    actionElement.setTag(reader.getAttributeValue(0));
                                    break;
                                }
                                case "criterias": {
                                    actionElement.setCriterias(Utils.escapeHTML(reader.getElementText()));
                                    break;
                                }
                                case "foundElements": {
                                    actionElement.setFoundElements(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "searchDuration": {
                                    actionElement.setSearchDuration(Integer.parseInt(reader.getElementText()));
                                }
                            }
                        }
                    }
                }
                if (event != 2) continue;
                if ("script".equals(reader.getLocalName()) && isTestInfo) {
                    htmlReport.setMainReport(new HtmlReportTestInfo(testInfo, htmlReport.getMainReport(), null, suiteName, this.contextExecution).getResult());
                    String mainReport = contentFilter.filter(htmlReport.getMainReport());
                    testCaseReportOutputStream.write(mainReport.getBytes());
                    String playlistTestInfo = new HtmlReportTestInfo(testInfo, reportSuiteTemplate, targetPath.resolve("ats-test-report.html").toString(), suiteName, this.contextExecution).getResult();
                    playlistTestInfo = contentFilter.filter(playlistTestInfo);
                    this.htmlReportPlaylist.processPlaylistTestInfo(playlistTestInfo);
                    continue;
                }
                if ("dataJson".equals(reader.getLocalName())) {
                    action.setAppDataJson(appDataJson);
                    appDataJson = new AppDataJson();
                    continue;
                }
                if ("element".equals(reader.getLocalName())) {
                    action.setActionElement(actionElement);
                    actionElement = new ActionElement();
                    continue;
                }
                if (!"action".equals(reader.getLocalName())) continue;
                String processedAction = htmlReportAction.processAction(action, appIcons, testInfo, reportSettings.devReport(), actionReportLineNumber);
                processedAction = contentFilter.filter(processedAction);
                testCaseReportOutputStream.write(processedAction.getBytes());
                this.htmlReportPlaylist.processPlaylistTestAction(processedAction, !ActionComment.class.getSimpleName().equals(action.getType()) && !ActionCallscript.class.getSimpleName().equals(action.getType()));
                ++actionReportLineNumber;
                this.playlistsDataCurrent.addAction(action.getType());
                this.reportLevelDurationCalculator.addActionDuration(action);
                actionsCountCalculator.addAction(action.getType());
                action = new Action();
            }
            testSummary.setCalculatedActionsCount(actionsCountCalculator.getCount());
            String footer = this.addActionsCountToFooter(htmlReport.getFooter(), testSummary);
            testCaseReportOutputStream.write(footer.getBytes());
            this.htmlReportPlaylist.processTestCaseFooter();
        }
    }

    private HtmlReport createReport() {
        return new HtmlReport(mainTemplate, styles, javascript);
    }

    private void updateCalculatedStepsCount() {
        this.contextExecution.project().getSuites().forEach(suite -> {
            SuiteSummary suiteSummary = this.summaryCalculator.updateCalculatedActionsCount(suite.getSuiteInfo(), suite.getSuiteSummary());
            suite.setSuiteSummary(suiteSummary);
        });
        ReportSummary reportSummary = this.summaryCalculator.updateCalculatedActionsCount(this.contextExecution.project().getSuites(), this.contextExecution.project().getReportSummary());
        this.contextExecution.project().setReportSummary(reportSummary);
    }

    private void writeJsonData(HtmlReportExecution htmlReportExecution) throws IOException {
        this.writeJsonData(this.playlistsDataLst, "playlist-data", htmlReportExecution.getFileWriter(), htmlReportExecution.getValidationFileWriter());
        this.writeJsonData(this.getCalculatedActionsCountByTestCases(this.contextExecution.project().getSuites()), "test-cases-actions-count-data", htmlReportExecution.getFileWriter(), htmlReportExecution.getValidationFileWriter());
        ReportDurationData reportDuration = this.reportLevelDurationCalculator.getReportDuration();
        this.contextExecution.project().setReportSummary(this.contextExecution.project().getReportSummary().withNewReportDurationData(reportDuration));
        if (!this.contextExecution.reportSettings().hideDurations() && !this.contextExecution.reportSettings().concatenationRun()) {
            this.writeJsonData(reportDuration, "report-duration-data", htmlReportExecution.getFileWriter(), htmlReportExecution.getValidationFileWriter());
        }
    }

    private void writeJsonData(Object data, String dataId, OutputStream mainReport, OutputStream validationReport) throws IOException {
        String jsonData = this.gson.toJson(data);
        String htmlData = String.format("<script type=\"application/json\" id=\"%s\">%s</script>", dataId, jsonData);
        mainReport.write(htmlData.getBytes());
        validationReport.write(htmlData.getBytes());
    }

    private Map<String, Map<String, Integer>> getCalculatedActionsCountByTestCases(List<Suite> suites) {
        return suites.stream().map(Suite::getSuiteInfo).flatMap(suiteInfo -> suiteInfo.getSummaries().stream()).collect(Collectors.toMap(TestSummary::getSuiteName, testSummary -> Map.of(testSummary.getTestName(), testSummary.getCalculatedActionsCount()), (suite1, suite2) -> Stream.concat(suite1.entrySet().stream(), suite2.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
    }

    private String addActionsCountToFooter(String footer, TestSummary summary) {
        return footer.replace("${test-case-actions-count}", this.gson.toJson(Map.of(summary.getSuiteName(), Map.of(summary.getTestName(), summary.getCalculatedActionsCount()))));
    }
}

