/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.models;

import com.ats.recorder.TestError;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TestSummary {
    private String actions;
    private String duration;
    private String executionTime;
    private String status;
    private String suiteName;
    private String testName;
    private String data;
    private String error;
    private String errorLine;
    private String errorScriptName;
    private List<TestError> testErrors;
    private long started;
    private boolean astvReportGenerated;
    private int calculatedActionsCount;
    private Set<String> groups = new HashSet<String>();

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public void setErrorLine(String errorLine) {
        this.errorLine = errorLine;
    }

    public String getErrorLine() {
        return this.errorLine;
    }

    public void setErrorScriptLine(String errorScriptName) {
        this.errorScriptName = errorScriptName;
    }

    public String getErrorScriptName() {
        return this.errorScriptName;
    }

    public List<TestError> getTestErrors() {
        return this.testErrors;
    }

    public void setTestErrors(List<TestError> testErrors) {
        this.testErrors = testErrors;
    }

    public String getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(String executionTime) {
        this.executionTime = executionTime;
    }

    public long getStarted() {
        return this.started;
    }

    public void setStarted(long started) {
        this.started = started;
    }

    public boolean isAstvReportGenerated() {
        return this.astvReportGenerated;
    }

    public void setAstvReportGenerated(boolean astvReportGenerated) {
        this.astvReportGenerated = astvReportGenerated;
    }

    public int getCalculatedActionsCount() {
        return this.calculatedActionsCount;
    }

    public void setCalculatedActionsCount(int calculatedActionsCount) {
        this.calculatedActionsCount = calculatedActionsCount;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestSummary summary = (TestSummary)o;
        return Objects.equals(this.actions, summary.actions) && Objects.equals(this.status, summary.status) && Objects.equals(this.suiteName, summary.suiteName) && Objects.equals(this.testName, summary.testName);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.status, this.suiteName, this.testName);
    }

    public String toString() {
        return "Summary{actions='" + this.actions + "', duration='" + this.duration + "', status='" + this.status + "', suiteName='" + this.suiteName + "', testName='" + this.testName + "', groups='[" + String.valueOf(this.groups) + "]'}";
    }

    public TestSummary deepCopy() {
        TestSummary copy = new TestSummary();
        copy.setActions(this.actions);
        copy.setDuration(this.duration);
        copy.setExecutionTime(this.executionTime);
        copy.setStatus(this.status);
        copy.setSuiteName(this.suiteName);
        copy.setTestName(this.testName);
        copy.setData(this.data);
        copy.setError(this.error);
        copy.setErrorLine(this.errorLine);
        copy.setError(this.errorScriptName);
        copy.setTestErrors(Optional.ofNullable(this.testErrors).filter(Objects::nonNull).map(nonNullTestErrors -> nonNullTestErrors.stream().map(TestError::deepCopy).collect(Collectors.toList())).orElse(null));
        copy.setStarted(this.started);
        copy.setAstvReportGenerated(this.astvReportGenerated);
        copy.setGroups(new HashSet<String>(this.groups));
        return copy;
    }
}

