/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.telemetry;

import com.ats.tools.telemetry.Collector;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CollectorBuilder {
    private static final String OTEL_ENDPOINT = "OTEL_ENDPOINT";
    private static final String OTEL_RESOURCE_ATTRIBUTES = "OTEL_RESOURCE_ATTRIBUTES";
    private String endPointUrl;
    private Map<String, String> resources;
    private MetricExporter metricExporter;

    public CollectorBuilder withEndPointUrl(String endPointUrl) {
        this.endPointUrl = endPointUrl;
        return this;
    }

    public CollectorBuilder withResources(Map<String, String> resources) {
        this.resources = resources;
        return this;
    }

    public CollectorBuilder withMetricExporter(MetricExporter metricExporter) {
        this.metricExporter = metricExporter;
        return this;
    }

    public static String getOpenTelemetryEndpoint() {
        return System.getenv(OTEL_ENDPOINT);
    }

    public static String getOpenTelemetryResources() {
        return System.getenv(OTEL_RESOURCE_ATTRIBUTES);
    }

    public MetricExporter getDefaultMetricExporter(String endPointUrl) {
        return OtlpGrpcMetricExporter.builder().setEndpoint(endPointUrl).build();
    }

    private String getEndPointUrl() {
        return this.endPointUrl;
    }

    public Collector build() {
        if (this.endPointUrl == null) {
            this.endPointUrl = CollectorBuilder.getOpenTelemetryEndpoint();
        }
        if (this.metricExporter == null && this.endPointUrl != null) {
            this.metricExporter = this.getDefaultMetricExporter(this.endPointUrl);
        }
        if (this.resources == null) {
            this.resources = CollectorBuilder.stringToMap(CollectorBuilder.getOpenTelemetryResources());
        }
        return new Collector(this.resources, this.metricExporter);
    }

    private static Map stringToMap(String attributesString) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{attributesString})) {
            return Collections.emptyMap();
        }
        String[] values = attributesString.split(",");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String value : values) {
            String[] parts = value.split("=");
            if (parts.length <= 1) continue;
            map.put(parts[0], parts[1]);
        }
        return map;
    }
}

