let isPopupOpened = false;
let isPlaylistNameInWidgetTruncated = false;
let playlistsData = null;
let currentAction = null;
let topBegin = 94;

class WidgetManager {
	constructor() {
        this.currentAction = null;
        this.currentTestCase = null;
        this.currentPlaylist = null;
        this.lstCurrentTestCases = null;
        this.topBegin = 94;
    }

    selectPlaylist(playlist) {
        this.initCurrentPlaylist(playlist);
        this.currentPlaylist = playlist;
    }

	initCurrentPlaylist(playlist) {
	    let playlistSection = document.querySelector("#current-playlist");
	    let playlistName = playlist.querySelector(".playlist-info-name-text");
	    if (!playlistName) {
	        playlistName = playlist.querySelector(".playlist-info-header");
	        playlistName = playlistName.id;
	    } else {
	        playlistName = playlistName.innerText;
	    }
		if (playlistSection && playlistName !== '') {
            playlistSection.innerText = playlistName;
            playlistSection.parentElement.title = playlistName;

            const lstTestcases = playlist.querySelectorAll(".test-name-text");
            this.fillTestCases(lstTestcases);

            this.selectCurrentPlaylist();
            this.highLighPlaylist(playlist);
        }
	}

    selectTestCase(testCase) {
        this.initCurrentTestCase(testCase);
        this.currentTestCase = testCase;
    }

	initCurrentTestCase(testCase) {
	    if (!testCase) return;
	    const testCaseSection = document.querySelector("#current-testcase");
	    const testCasePath = document.querySelector("#current-testcase-path");
	    const testCaseName = testCase.querySelector(".test-name-text");

		if (testCaseSection && testCaseName) {
		    const parties = testCaseName.title.split(".");
		    if (parties && parties.length > 0) {
                testCaseSection.innerText = parties[parties.length - 1];
                const pathTxt = parties.slice(0, parties.length - 1).join(".");
                if (pathTxt !== '') {
                    testCasePath.innerText = pathTxt;
                } else {
                    testCasePath.innerText = "...";
                }
                testCaseSection.parentElement.title = testCaseName.innerText;

                this.selectCurrentTestcase();
                this.highLighTestCase(testCase);
		    }
		}
	}

    fillPlaylists(playlistData) {
        const lstPlaylist = document.getElementById('lst-playlist');
        let maxStr = '';
        let maxLength = 0;
        let status = null;

        lstPlaylist.innerHTML = playlistData.map(playlist => {
            const playlistName = playlist.name;
            const element = document.querySelector('.playlists-container [id="' + playlistName + '"]');
            if (element) {
                const passed = element.querySelector('.result-pass-icon-transparent');
                if (passed) {
                    status = '<div class="result-pass-icon-transparent" style="width: 20px;height: 20px;"></div>';
                } else {
                    status = '<div class="result-failed-icon" style="width: 20px;height: 20px;"></div>';
                }
            }

            if (playlistName.length > maxLength) {
                maxLength = playlistName.length;
                maxStr = playlistName;
            }
            return `<a href="#" id='${playlistName}' onclick="widgetManager.navigateToPlaylist('${playlistName}')">
                       ${playlistName}${status}
                    </a>`;
        }).join('');

        const combobox = document.getElementById('current-playlist');
        const maxLenPx = getTextWidthElem(maxStr, combobox);
        combobox.style.width = maxLenPx+'px';
    }

    fillTestCases(lstCurrentTestCases) {
        const lstTestCases = document.getElementById('lst-testcase');
        let lastElement = null;
        let path = false;
        let maxStr = '';

        lstTestCases.innerHTML = '';
        const fragment = document.createDocumentFragment();

        Array.from(lstCurrentTestCases).forEach(testCase => {
            const testCaseId = testCase.title.replace(/\./g, "");
            const parties = testCase.title.split(".");

            const element = testCase.parentElement.parentElement.parentElement.parentElement;
            const passed = element.querySelector('.result-pass-icon');
            if (passed) {
                status = '<div class="result-pass-icon-transparent" style="width: 20px;height: 20px;margin-top: 3px;"></div>';
            } else {
                const asasuite = element.querySelector('.result-pass-icon-continue');
                if (asasuite) {
                    status = '<div class="result-pass-icon-continue" style="width: 20px;height: 20px;margin-top: 3px;"></div>';
                } else {
                    status = '<div class="result-failed-icon" style="width: 20px;height: 20px;margin-top: 3px;"></div>';
                }
            }

            if (parties && parties.length > 0) {
                const testCaseName = parties[parties.length - 1];
                let testCasePath = parties.slice(0, parties.length - 1).join(".");
                if (testCasePath === '') {
                    testCasePath = "...";
                }

                const anchor = document.createElement('a');
                anchor.href = "#";
                anchor.id = testCaseId;
                anchor.className = "itemTestCaseLink";
                anchor.innerHTML = `
                    <div class="test-case-content">
                        <div class="menu-item-testcase-path">${testCasePath}</div>
                        <div class="menu-item-testcase-name">${testCaseName}</div>
                    </div>${status}
                `;

                if (testCasePath.length > maxStr.length) {
                    maxStr = testCasePath;
                    path = true;
                }
                if (testCaseName.length > maxStr.length) {
                    maxStr = testCaseName;
                    path = false;
                }

                anchor.addEventListener('click', () => {
                    widgetManager.navigateToTestcase(testCase.title);
                });

                fragment.appendChild(anchor);

            }
        });

        lstTestCases.appendChild(fragment);

        const combobox = document.getElementById('current-testcase').parentElement;
        const dummyElement = document.createElement('div');
        if (path) {
            dummyElement.style.fontSize = '10px';
        } else {
            dummyElement.style.fontSize = '14px';
        }
        dummyElement.style.fontFamily = 'Arial, serif';
        document.body.appendChild(dummyElement);
        const maxLenPx = getTextWidthElem(maxStr, dummyElement);
        document.body.removeChild(dummyElement);
        combobox.style.width = maxLenPx+'px';
    }

    openPlaylist(playlist) {
        let switchElement = playlist.querySelector('.display-toggle-icon-down, .display-toggle-icon-right');
        let dataElement = playlist.querySelector('.playlist-data-general');

        if (!playlist.classList.contains('chart-rendered'))  {
            buildChartTypesRadar(playlist, playlistsData);
            buildChartTests(playlist, playlistsData);
            playlist.classList.add('chart-rendered');
        }
        this.currentPlaylist = playlist;

        dataElement.className = 'playlist-data-general';
        switchElement.className = 'display-toggle-icon-down';
    }

    openTestCase(testCase) {
        let switchElement = testCase.querySelector('.display-toggle-icon-down, .display-toggle-icon-right');
        let dataElement = testCase.querySelector('.test-case-body');
        this.currentTestCase = testCase;
        dataElement.className = 'test-case-body';
        switchElement.className = 'display-toggle-icon-down';
        activateTestCaseGraph(switchElement);
    }

    scrollTo(elementToScroll) {
        if (!elementToScroll) {
            return;
        }
        const elementPosition = elementToScroll.getBoundingClientRect().top;
        const offsetPosition = elementPosition + window.pageYOffset;
        const headerHeight = 94;
        const scrollPosition = offsetPosition - headerHeight - 10;

        setTimeout(() => {
            window.scrollTo({
                top: scrollPosition,
                behavior: 'smooth'
            });
        }, 100);
    }

	toggleElement(elementId, switchElement, type, scroll) {
	    let element = document.getElementById(elementId);
        let currentSection = null;
        let baseClassName = null;

        if (type === 'actions') {
            baseClassName = 'actions-container';
            currentSection = switchElement.parentElement;
        } else if (type === 'testCase') {
            baseClassName = 'test-case-body';
            currentSection = switchElement.parentElement.parentElement.parentElement.parentElement.parentElement;
            this.currentTestCase = currentSection;
            this.initCurrentTestCase(currentSection);
            activateTestCaseGraph(switchElement);
        } else if (type === 'suite') {
            baseClassName = 'playlist-data-general';
            currentSection = switchElement.parentElement.parentElement.parentElement;
            this.currentPlaylist = currentSection;
            this.initCurrentPlaylist(currentSection);

            if (!this.currentPlaylist.classList.contains('chart-rendered'))  {
                let dataElement = this.currentPlaylist.querySelector('.playlist-data-general');
                buildChartTypesRadar(this.currentPlaylist, playlistsData);
                buildChartTests(this.currentPlaylist, playlistsData);
                this.currentPlaylist.classList.add('chart-rendered');
            }
            this.currentTestCase = element.querySelector('.general-layout');
            this.initCurrentTestCase(this.currentTestCase);
        } else if (type === 'errors-group') {
            baseClassName = 'non-blocking-errors-items';
        } else {
            console.error('Unknown type:', type);
            return;
        }

        if (baseClassName !== 'non-blocking-errors-items') {
            this.closeAll();
        }

        element.className = element.className === `${baseClassName} collapsed` ? baseClassName : `${baseClassName} collapsed`;
        switchElement.className = switchElement.className === 'display-toggle-icon-right' ? 'display-toggle-icon-down' : 'display-toggle-icon-right';

        if (!currentSection) return;
        if (scroll || scroll === undefined) {
            this.scrollTo(currentSection);
        }
    }

    navigateToPlaylist(playlist) {
        let element = null;
        if (playlist === undefined) {
            if (this.currentPlaylist ===  undefined) {
                let playlists = document.getElementsByClassName('playlist');
                this.currentPlaylist = playlists[playlists.length - 1];
            }
            element = this.currentPlaylist;
        } else if (typeof playlist === 'string') {
            element = document.querySelector('.playlists-container [id="' + playlist + '"]');
            if (element) {
                element = element.parentElement;
            } else {
                return;
            }
        } else {
            element = playlist;
        }

        this.currentPlaylist = element;
        this.initCurrentPlaylist(element);

        this.currentTestCase = element.querySelector('.general-layout');
        this.initCurrentTestCase(this.currentTestCase);

        this.closeAll();
        this.openPlaylist(element);

        this.openTestCase(this.currentTestCase);
        this.scrollTo(element);
    }

    navigateToPrevPlaylist() {
        if (this.currentPlaylist) {
            if (!playlistsData || playlistsData.length === 1) return;
            this.currentPlaylist = this.currentPlaylist.previousElementSibling;
            if (!this.currentPlaylist) {
                let playlists = document.getElementsByClassName('playlist');
                this.currentPlaylist = playlists[playlists.length - 1];
            }
            if (!playlistsData || playlistsData.length === 1) return;
        } else {
            let playlists = document.getElementsByClassName('playlist');
            this.currentPlaylist = playlists[playlists.length - 1];
        }
        this.navigateToPlaylist(this.currentPlaylist);
    }

    navigateToNextPlaylist() {
        if (this.currentPlaylist) {
            if (!playlistsData || playlistsData.length === 1) return;
            this.currentPlaylist = this.currentPlaylist.nextElementSibling;
            if (!this.currentPlaylist || this.currentPlaylist.id == 'playlist-data') {
                this.currentPlaylist = document.getElementsByClassName('playlist')[0];
            }
        } else {
            this.currentPlaylist = document.getElementsByClassName('playlist')[0];
        }
        this.navigateToPlaylist(this.currentPlaylist);
    }

    navigateToTestcase(testCase) {
        let element = testCase;
        if (testCase === undefined) {
            if (this.currentTestCase ===  undefined) {
                this.currentTestCase = this.currentPlaylist.getElementsByClassName('general-layout')[0];
            } else {
                element = this.currentTestCase;
            }
        } else if (typeof testCase === 'string') {
            element = this.currentPlaylist.querySelector('[id*="' + testCase + '"].general-layout');
            if (!element) {
                return;
            }
        }

        this.currentTestCase = element;
        this.initCurrentTestCase(element);
        this.closeAll();
        this.openTestCase(element);
        this.scrollTo(element);
    }

    navigateToNextTestcase() {
        if (this.currentPlaylist) {
            if (this.currentTestCase) {
                this.currentTestCase = this.currentTestCase.nextElementSibling;
                if (!this.currentTestCase) {
                    this.currentTestCase = this.currentPlaylist.getElementsByClassName('general-layout')[0];
                }
            } else {
                this.currentTestCase = this.currentPlaylist.getElementsByClassName('general-layout')[0];
            }
        }
        this.navigateToTestcase(this.currentTestCase);
    }

    navigateToPrevTestcase() {
        if (this.currentPlaylist) {
            if (this.currentTestCase) {
                this.currentTestCase = this.currentTestCase.previousElementSibling;
                if (!this.currentTestCase) {
                    let testCases = this.currentPlaylist.getElementsByClassName('general-layout');
                    this.currentTestCase = testCases[testCases.length - 1];
                }
            } else {
                this.currentTestCase = this.currentPlaylist.getElementsByClassName('general-layout')[0];
            }
        }
        this.navigateToTestcase(this.currentTestCase);
    }

    selectCurrentPlaylist() {
        const allAnchors = document.querySelectorAll('#lst-playlist a');
        allAnchors.forEach(anchor => anchor.classList.remove('selected'));

        const playlistId = this.currentPlaylist.querySelector('.playlist-info-header').id;
        const anchor = document.querySelector('#lst-playlist [id="' + playlistId + '"]');
        if (anchor) {
            anchor.classList.add('selected');
        }
    }

    selectCurrentTestcase() {
        const allAnchors = document.querySelectorAll('#lst-testcase a');
        allAnchors.forEach(anchor => anchor.classList.remove('selected'));

        let testCaseId = this.currentTestCase.id.split(' ')[0];
        testCaseId = testCaseId.split(".").join("");

        const anchor = document.querySelector('#lst-testcase #'+ testCaseId);
        if (anchor) {
            anchor.classList.add('selected');
        }
    }

    highLighTestCase(testCase) {
        const elements = document.querySelectorAll(".general-layout");
        elements.forEach(element => element.style = "");

        testCase.style.border = "3px solid rgba(211, 211, 211, 1)";
        testCase.style.borderRadius = "12px";
        testCase.style.padding = "0";
    }

    highLighPlaylist(playlist) {
        const elements = document.querySelectorAll(".playlist-info-header");
        elements.forEach(element => element.style = "");

        let element = playlist.querySelector(".playlist-info-header");
        element.style.border = "3px solid #6ea1ff";
        element.style.border = "3px solid #6ea1ff";
        element.style.padding = "0px 20px";
    }

    closeAll() {
        const divs = document.querySelectorAll('div.display-toggle-icon-down');
        divs.forEach(toggleDiv => {
            const onClickContent = toggleDiv.getAttribute('onclick');
            const match = onClickContent.match(/"([^"]+)"/g);
            const lastArgument = match[match.length - 1].replace(/"/g, '');
            let dataDiv = null;
            if (lastArgument === 'suite') {
                dataDiv = toggleDiv.parentElement.parentElement.nextElementSibling;
                toggleDiv.parentElement.parentElement.style.border = "";
            } else if (lastArgument ===  'testCase') {
                dataDiv = toggleDiv.parentElement.parentElement.nextElementSibling;
                toggleDiv.parentElement.parentElement.style.border = "";
            } else if (lastArgument === 'actions') {
                dataDiv = toggleDiv.parentElement.nextElementSibling;
            }
            if (dataDiv) {
                let currentPlaylistId = null;
                if (this.currentPlaylist) {
                    currentPlaylistId = this.currentPlaylist.querySelector(".playlist-data-general").id;
                }

                let currentTestcaseId = null;
                if (this.currentTestCase) {
                    currentTestcaseId = this.currentTestCase.querySelector(".test-case-body").id;
                }

                if (currentPlaylistId !== dataDiv.id &&
                    currentTestcaseId !== dataDiv.id) {
                        dataDiv.className = dataDiv.classList[0] + ' collapsed';
                        toggleDiv.className = 'display-toggle-icon-right';
                }
            }
        });
    }

    unwrapFirstPlayList() {
        let elementNodeListOf = document.querySelectorAll('.display-toggle-icon-right');
        if (elementNodeListOf.length > 0) {
            const onclickAttr = elementNodeListOf.item(0).getAttribute('onclick');
            const paramsString = onclickAttr.match(/\((.*)\)/)[1];
            const params = paramsString.match(/"[^"]*"|\bthis\b|\btrue\b|\bfalse\b|\bnull\b|\d+/g);
            const cleanedParams = params.map(p => p === 'this' ? p : p.replace(/^"|"$/g, ''));
            widgetManager.toggleElement(cleanedParams[0], elementNodeListOf.item(0), cleanedParams[2], false);

            activateTestCaseGraph(elementNodeListOf.item(0));
        } else {
            let switchDown = document.querySelector('.display-toggle-icon-down');
            activateTestCaseGraph(switchDown);
        }
    }
}

function getTextWidth(text, font) {
    const canvas = document.createElement('canvas');
    const context = canvas.getContext('2d');
    context.font = font;
    return context.measureText(text).width;
}

function getTextWidthElem(text, element) {
    const style = window.getComputedStyle(element || document.body);

    const canvas = document.createElement('canvas');
    const context = canvas.getContext('2d');

    context.font = `
        ${style.fontWeight}
        ${style.fontSize}
        ${style.fontFamily}
    `.replace(/\s+/g, ' ').trim();

    const metrics = context.measureText(text);
    return Math.ceil(metrics.width);
}

function processWidowResize() {
    let minimalWindowWidth = 1858;
    let startLeftPosition = 1608;
    let fixedDiv = document.getElementsByClassName('navigation-widget-container')[0];
    let windowWidth = window.innerWidth;

    if (fixedDiv) {
        if (windowWidth < minimalWindowWidth) {
            fixedDiv.style.left = `${startLeftPosition - (minimalWindowWidth - windowWidth + 35)}px`;
        } else {
            fixedDiv.style.left = 'calc(50% + 650px)';
        }
    }
}

function applyVerticalStyle(imageSrc, imageModal, isRemove) {
    if (isRemove) {
        if (imageSrc.includes('video')) {
            imageModal.childNodes[3].classList.remove('image-vertical');
        } else {
            imageModal.childNodes[1].classList.remove('image-vertical');
        }
    } else {
        if (imageSrc.includes('video')) {
            imageModal.childNodes[3].classList.add('image-vertical');
        } else {
            imageModal.childNodes[1].classList.add('image-vertical');
        }
    }
}

function activateTestCaseGraph(switchElement) {
    // duration-filter-off-start
    const durationChartContainer = switchElement.parentElement.parentElement.parentElement.querySelector('.charts-container-chart-element.chart-duration');
    if (durationChartContainer === null) {
        console.log("durationChartContainer is null");
        return;
    }
    if (!durationChartContainer.classList.contains('chart-rendered')) {
        buildChartDuration(durationChartContainer);
        durationChartContainer.classList.add('chart-rendered');
    }
    // duration-filter-off-end

    const chartTypeContainer = switchElement.parentElement.parentElement.parentElement.querySelector('.charts-container-chart-element.chart-types');
    if (chartTypeContainer === null) {
            console.log("chartTypeContainer is null");
            return;
        }
    if (!chartTypeContainer.classList.contains('chart-rendered'))  {
        const baseElement = chartTypeContainer.parentElement.parentElement.parentElement.parentElement.parentElement;
        const data = [
            baseElement.querySelectorAll('.atl-navigation').length,
            baseElement.querySelectorAll('.atl-calls').length,
            baseElement.querySelectorAll('.atl-user-actions').length,
            baseElement.querySelectorAll('.atl-assert').length,
            baseElement.querySelectorAll('.atl-technical').length,
            baseElement.querySelectorAll('.atl-others').length
        ];
        buildChartTypes(chartTypeContainer, data);

        chartTypeContainer.classList.add('chart-rendered');
    }
}

function toggleActionsView(toggleButton) {
    toggleButton.parentElement.childNodes[1].click();
}

function toggleCollapsedElementsWithNavigationWidget(elementId) {
    let testCaseElement = document.getElementById(elementId);
    let actionsSectionElement = document.getElementById(elementId.replace('test-data', 'actions-container'));

    let suiteElement = testCaseElement.parentElement.parentElement.parentElement.parentElement.parentElement;
    Array.from(suiteElement.getElementsByClassName('test-case-body')).forEach(el => el.classList.add('collapsed'));
    Array.from(suiteElement.getElementsByClassName('display-toggle-icon-down')).forEach(el => el.className = 'display-toggle-icon-right');

    Array.from(testCaseElement.parentElement.getElementsByClassName('display-toggle-icon-right')).forEach(el => el.className = 'display-toggle-icon-down');

    testCaseElement.className = 'test-case-body';
    actionsSectionElement.className = 'actions-container';

    let switchElement = testCaseElement.previousElementSibling.querySelector("div").querySelector("div");
    activateTestCaseGraph(switchElement);
}

function applyTruncationToScriptNamesInAction() {
    document.querySelectorAll('.script-name-text').forEach(element => {
        if (element.parentElement.parentElement.parentElement.parentElement.classList.contains("status-line-non-functional")) {
            if (element.clientWidth > 1210) {
                element.classList.add('truncated-text-1210');
            }
        } else {
            if (element.clientWidth > 790) {
                element.classList.add('truncated-text-790');
            }
        }
    });
}

function applyTruncationToSuiteName() {
    document.querySelectorAll('.playlist-info-name-text').forEach(element => {
        if (element.clientWidth > 460) {
            element.classList.add('truncated-text-460');
        }
    });
}

function applyTruncationToTestName() {
    document.querySelectorAll('.test-name-text').forEach(element => {
        const domainName = element.querySelector('.test-case-domain-name');
        const testName = element.querySelector('.test-case-name');
        if (!domainName) {
            if (element.clientWidth > 670) {
                element.classList.add('truncated-text-670');
            }
        } else {
            if (domainName.clientWidth > 670) {
                domainName.classList.add('truncated-text-670');
            }
            if (testName.clientWidth > 670) {
                testName.classList.add('truncated-text-670');
            }
        }
    });
}

function displayActionsCountForTestCases() {
    const jsonData = document.getElementById("test-cases-actions-count-data");
    if (jsonData && jsonData.textContent) {
        let totalActionsCount = 0;
        for (const [suite, testCases] of Object.entries(JSON.parse(jsonData.textContent))) {
            for (const [testCase, actionsCount] of Object.entries(testCases)) {
                document.getElementById(`${suite}-${testCase}-actions-count`).innerHTML = actionsCount;
                totalActionsCount += actionsCount;
            }
        }
        document.getElementById("report-total-actions-count").innerHTML = totalActionsCount;
        document.querySelectorAll('[id^="null-test-summary"]').forEach(element => element.innerHTML = 'No value');
    } else {
        console.warn('actions count data is not available');
    }
}

function navigateToNextAndPrevSuiteById(button, isNext) {
    let id = button.parentElement.childNodes[3].title;
    const containers = Array.from(document.querySelectorAll('.playlist-info-header'));
    const currentIndex = containers.findIndex(div => div.id === id);
    if (currentIndex === -1) {
        console.log('Element not found');
        return;
    }
    const prevElement = containers[(currentIndex - 1 + containers.length) % containers.length];
    const nextElement = containers[(currentIndex + 1) % containers.length];

    if (isNext) {
        let suiteElementToggle = nextElement.getElementsByClassName('display-toggle-icon-right')[0];
        if (suiteElementToggle) {
            suiteElementToggle.click();
        }
        navigateToElementByTestId(nextElement.id, true);
    } else {
        let suiteElementToggle = prevElement.getElementsByClassName('display-toggle-icon-right')[0];
        if (suiteElementToggle) {
            suiteElementToggle.click();
        }
        navigateToElementByTestId(prevElement.id, true);
    }
}

function drawChartDonut(container, prcValues, labels) {
    if (!container) return null;

    const options = {
        series: prcValues,
        height: 110,
        width: 230,
        parentHeightOffset: 0,
        offsetX: 0,
        offsetY: 30,
        zoom: {
            enabled: false
        },
        toolbar: {
            show: false
        },
        grid: {
            padding: {
                top: 0,
                right: 0,
                bottom: -40,
                left: 0
            }
        },
        markers: {
            size: 2
        },
        labels: labels,
        chart: {
            type: 'donut'
        },
        plotOptions: {
            pie: {
                donut: {
                    size: '40%'
                }
            }
        },
        colors: ['#9dbf3f', '#3B5761', '#ecf0df'],
        tooltip: {
            enabled: true,
            shared: false,
            style: {
                fontSize: '10px',
                fontFamily: 'Arial',
                colors: ['#080808']
            },
            x: {
                show: false,
            },
            y: {
                show: true,
                formatter: function(value) {
                    return value.toFixed(2) + '%';
                }
            },
            theme: 'dark',
            fillSeriesColor: false
        },
        dataLabels: {
            formatter: function(value) {
                return value.toFixed(2) + '%';
            },
            style: {
                fontSize: '10px',
                fontFamily: 'Arial',
                colors: ['#080808']
            }
        },
        legend: {
            position: 'top',
            horizontalAlign: 'center',
            fontSize: '10px',
            fontFamily: 'Arial'
        }
    };

    const chart = new ApexCharts(container, options);
    chart.render();

    return chart;
}

function drawChartRadar(canvas, valuesRadar, dimensions) {
    const categories = ['Navigation','Callscript','User action','Assertion','Technical','Others'];
    options = {
        chart: {
            type: 'radar',
            height: dimensions.height,
            width: dimensions.width,
            parentHeightOffset: 0,
            offsetX: dimensions.offsetX,
            offsetY: dimensions.offsetY,
            zoom: {
                enabled: false
            },
            toolbar: {
                show: false
            }
        },
        grid: {
            padding: {
                top: -15,
                right: -15,
                bottom: -30,
                left: 0
            }
        },
        markers: {
            size: 3,
            colors: ['#FF5733'],
            strokeColors: '#ffffff',
            strokeWidth: 2,
            hover: {
                size: 5
            }
        },
        xaxis: {
            categories: categories,
            labels: {
                style: {
                    fontFamily: 'Arial, serif',
                    fontSize: '9px',
                    fontWeight: 'normal',
                }
            }
        },
        yaxis: {
            show: false
        },
        tooltip: {
            enabled: true,
            shared: false,
            style: {
              fontFamily: 'Arial, serif',
              fontSize: '9px',
              fontWeight: 'normal',
            },
            x: {
                show: false
            },
            y: {
                title: {
                    formatter: function(seriesName, { dataPointIndex }) {
                        return categories[dataPointIndex];
                    }
                },
                formatter: function(value) {
                    return value;
                }
            }
        },
        dataLabels: {
            enabled: false
        },
        series: [{ name: 'My Data', data: valuesRadar }]
    };

    const chart = new ApexCharts(canvas, options);
    chart.render();
}

function buildChartTests(playlist, playlistData) {
    if (playlist === null || playlistData.length === 0) return;

    let playlistDataStruct;
    const nameElement = playlist.querySelector('.playlist-info-name-text');
    if (nameElement === null) {
        playlistDataStruct = playlistData[0];
    } else {
        playlistDataStruct = playlistData.find(playlist => playlist.name === nameElement.innerHTML);
    };

    const values = [playlistDataStruct.passed, playlistDataStruct.failed, playlistDataStruct.filtered];
    const total = values.reduce((sum, num) => sum + num, 0);
    const percentages = total > 0 ? values.map(value => roundTo(((value / total) * 100), 2)) : values.map(() => 0);

    const labels = ['Passed', 'Failed', 'Filtered'];
    drawChartDonut(playlist.querySelector('.chart-tests'), percentages, labels);
    return values;
}

// duration-filter-off-start
function buildChartDuration(container) {
    let dataElements = Array.from(container.parentElement.parentElement.parentElement.parentElement.querySelectorAll('.header'));
    let actionLabels = [];
    const peaks = dataElements.map((el, index) => {
        let actionLabelElement = el.querySelector('.action-name');
        actionLabels.push(actionLabelElement ? actionLabelElement.textContent.trim() : null);
        let dataArray = el.classList[1].split("-");
        return Number(dataArray[dataArray.length - 1] /1000 + index / '1e6').toFixed(2);
    });

    const peaksWithElements = dataElements.map((el, index) => {
        let dataArray = el.classList[1].split("-");
        return {"value": Number(dataArray[dataArray.length - 1] + index / '1e6'), "element": el};
    });

    let cumul = 0;
    const xAxisValues = peaks.map(v => Math.ceil(cumul += +v));

    let step = Math.max(Math.floor(peaks.length / 5), 1);
    var options = {
        chart: {
            type: 'line',
            height: 120,
            width: 230,
            parentHeightOffset: -15,
            offsetX: -9,
            offsetY: 0,
            zoom: {
                enabled: false
            },
            toolbar: {
                show: false
            },
            grid: {
                padding: {
                    top: -20,
                    right: 3,
                    bottom: -30,
                    left: 5
                }
            },
            events: {
                click: function(event, chartContext, config) {
                    const dataPointIndex = config.dataPointIndex;
                    if (dataPointIndex !== -1) {
                        const targetElement = peaksWithElements[dataPointIndex].element;

                        let toggleElement = targetElement.parentElement.parentElement.parentElement.parentElement.querySelector('.display-toggle-icon-right');
                        if (toggleElement) {
                            toggleElement.click();
                        }
                        targetElement.scrollIntoView({ behavior: 'smooth', block: 'center' });

                        let statusLine = targetElement.querySelector("div");
                        highlightElement(statusLine.parentElement.parentElement);
                    }
                }
            }
        },
        series: [{
            name: '',
            data: peaks
        }],
        dataLabels: {
            enabled: false,
            formatter: function(value, {dataPointIndex}) {
                return actionLabels[dataPointIndex];
            }
        },
        xaxis: {
            categories: xAxisValues,
            tickAmount:step,
            labels: {
                show: true,
                formatter: function (value) {
                  return value + ' s';
                },
                style: {
                    fontSize: 10
                },
            },
        },
        yaxis: {
            labels: {
                style: {
                    fontSize: 10
                },
            },
            min: 0,
            max: Math.max(...peaks.map((Number)))
        },
        tooltip: {
            enabled: true,
            shared: false,
            style: {
              fontSize: '10px'
            },
            x: {
                show: false
            },
            y: {
                formatter: function(value, {dataPointIndex}) {
                    return actionLabels[dataPointIndex] + ' - ' + Math.round(peaksWithElements[dataPointIndex].value / 10) + ' ms';
                }
            }
        },
        stroke: {
            width: 1
        },
        colors: ['#00BAEC'],
        markers: {
            size: 2,
            colors: ['#FFA41B'],
            strokeWidth: 1,
            hover: {
              size: 2
            }
        }
    };
    var chart = new ApexCharts(container,options);
    chart.render();
}
// duration-filter-off-end

function highlightElement(element) {
    const color = "#c7c7c7";
    const bgcolor = "#f2f2f2";

    if (currentAction) {
        currentAction.style.border = "";
        currentAction.style.backgroundColor = "";
    }

    element.style.border = "1px solid " + color;
    element.style.backgroundColor = bgcolor;
    currentAction = element;
}

function buildChartTypes(container, dataTypes) {
    const values = dataTypes;
    const categories = ["Navigation", "Callscript", "User action", "Assertion", "Technical", "Others"];
    const colors = ["#1BBC9B", "#3498DB", "#72B500", "#EE6AB9", "#6E4AD3", "#7D7D7D"];

    options = {
        chart: {
            type: 'bar',
            height: 112,
            width: 230,
            parentHeightOffset: -15,
            offsetX: -9,
            offsetY: 0,
            zoom: {
                enabled: false
            },
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                distributed: true
            }
        },
        xaxis: {
            categories,
            labels: {
                show: false
            },
            axisBorder: {
                show: false
            },
            axisTicks: {
                show: false
            },
        },
        yaxis: {
          labels: {
            style: {
              fontSize: '10px',
              fontFamily: 'Arial'
            }
          }
        },
        tooltip: {
            enabled: true,
            shared: false,
            style: {
              fontSize: '10px'
            },
            x: {
                show: false
            },
            y: {
                title: {
                    formatter: () => ''
                },
                formatter: function(value, {dataPointIndex}) {
                    return categories[dataPointIndex] + ' - ' + value;
                }
            }
        },
        grid: {
            padding: {
                top: -20,
                right: 3,
                bottom: -10,
                left: 5
            }
        },
        dataLabels: {
            enabled: false
        },
        legend: {
            position: 'right',
            fontSize: '10px',
            fontFamily: 'Arial',
            offsetY: -25,
            itemMargin: {
                horizontal: 0,
                vertical: 1
            }
        },
        colors,
            series: [{
                data: values
            }]
        };

    const chart = new ApexCharts(container, options);
    chart.render();
}

function buildChartTypesRadar(playlist, playlistData) {
    if (playlist === null || playlistData.length === 0) return;

    let playlistDataStruct;
    const nameElement = playlist.querySelector('.playlist-info-name-text');
    if (nameElement === null) {
        playlistDataStruct = playlistData[0];
    } else {
        playlistDataStruct = playlistData.find(playlist => playlist.name === nameElement.innerHTML);
    };

    let valuesRadar = playlistDataStruct.actions.map(action => action.value);
    const canvas = playlist.querySelector('.charts-container-chart-element.chart-types-suite');
    const dimensions = {
        height: 243,
        width: 270,
        offsetX: -2,
        offsetY: -20,
    };
    drawChartRadar(canvas, valuesRadar, dimensions);
}

function buildTopChartActions() {
    const categories = ['Navigation', 'Calls', 'UserAction', 'Assertion', 'Technical', 'Others'];
    const valuesRadar = new Array(categories.length).fill(0);
    for (const playlist of playlistsData) {
        for (const action of playlist.actions) {
            const index = categories.indexOf(action.name);
            if (index !== -1) {
                valuesRadar[index] += action.value;
            }
        }
    }
    const canvas = document.querySelector('.charts-container-chart-element.chart-actions-report');
    const dimensions = {
        height: 300,
        width: 320,
        offsetX: 10,
        offsetY: -10,
    };
    drawChartRadar(canvas, valuesRadar, dimensions);
}

function buildTopChartTests() {
    const values = new Array(2).fill(0);
    for (const playlist of playlistsData) {
        values[0] += playlist.passed;
        values[1] += playlist.failed;
    }
    const total = values.reduce((sum, num) => sum + num, 0);
    const percentages = total > 0 ? values.map(value => roundTo(((value / total) * 100), 2)) : values.map(() => 0);

    const canvas = document.querySelector('.charts-container-chart-element.chart-tests-report');
    const labels = ['Passed', 'Failed'];
    drawChartDonut(canvas, percentages, labels)
}

function buildTopChartPlaylists() {
    let playlists = Array.from(document.querySelectorAll('.playlist'));
    let values = [0, 0];

    playlists.forEach(playlist => {
        const resultPass = playlist.querySelector('.result-pass-icon-transparent');
        if (resultPass === null) {
            values[1] = values[1] + 1;
        } else {
            values[0] = values[0] + 1;
        }
    });
    const total = values.reduce((sum, num) => sum + num, 0);
    const percentages = total > 0 ? values.map(value => roundTo(((value / total) * 100), 2)) : values.map(() => 0);

    const canvas = document.querySelector('.charts-container-chart-element.chart-results-report');
    const labels = ['Passed', 'Failed'];
    drawChartDonut(canvas, percentages, labels)
}

function applyHeightToIframes() {
    let iFrames = document.getElementsByTagName('iFrame');
    if (iFrames) {
        try {
            Array.from(iFrames).forEach(element => {
                if (element) {
                    element.style.height = element.contentWindow.document.body.scrollHeight + 40 + 'px';
                    let iframeDocument = element.contentDocument || element.contentWindow.document;
                    let style = iframeDocument.createElement('style');
                    style.textContent = "body { font-family: 'Arial', sans-serif; }";
                    iframeDocument.head.appendChild(style);
                }
            });
        } catch(error) {
            console.error("function applyHeightToIframes, erreur :", error);
        }
    }
}

function roundTo(num, precision) {
  const factor = Math.pow(10, precision);
  return Math.round(num * factor) / factor;
}

// concat-filter-off-start
// duration-filter-off-start
function displayReportDuration() {
    const jsonData = document.getElementById("report-duration-data");
    const durationData = JSON.parse(jsonData.textContent);
    document.querySelector('#report-functional-duration').innerText = durationData.totalFunctionalDuration;
    document.querySelector('#report-technical-duration').innerText = durationData.totalTechnicalDuration;
    document.querySelector('#user-actions-duration').innerText = durationData.userActionDuration;
    document.querySelector('#assertions-duration').innerText = durationData.assertionDuration;
    document.querySelector('#technical-duration').innerText = durationData.technicalDuration;
    document.querySelector('#others-duration').innerText = durationData.othersDuration;
    document.querySelector('#navigation-duration').innerText = durationData.navigationDuration;
    document.querySelector('#call-script-duration').innerText = durationData.callScriptDuration;
    document.querySelector('#miscellaneous-duration').innerText = durationData.miscellaneousDuration;
}
// duration-filter-off-end
// concat-filter-off-end

function displayTopGRaph() {
    if (playlistsData && playlistsData.length > 1) {
        // concat-filter-off-start
        // duration-filter-off-start
        displayReportDuration();
        // duration-filter-off-end
        // concat-filter-off-end
        buildTopChartPlaylists();
        buildTopChartTests();
        buildTopChartActions();
    } else {
        const divTopTest = document.querySelector('.suits-container.executed-tests');
        const divTopResults = document.querySelector('.suits-container.executed-playlists');
        const divTopActions = document.querySelector('.charts-container-chart-test.actions');
        if (divTopTest && divTopActions && divTopResults) {
            divTopTest.style.display = 'none';
            divTopActions.style.display = 'none';
            divTopResults.style.display = 'none';
        }
    }
}

function selectAction(actionContainer) {
    console.log("actionContainer: ", actionContainer);
    highlightElement(actionContainer);
}

function navigateToElementByTestId(testId, isSuite) {
    testId = testId.replaceAll(',', '.');
    if (!isSuite) {
        toggleCollapsedElementsWithNavigationWidget(testId + '-test-data');
    }
    document.getElementById(testId).scrollIntoView({
        behavior: 'instant',
        block: 'start',
    });
}

function navigateToElementById(elementIdWithIndex, errorElement, isBlockingError) {
    let errorParentElement = isBlockingError ? errorElement.parentElement.parentElement : errorElement.parentElement.parentElement.parentElement.parentElement.parentElement;

    let toggleButtonElement = errorParentElement.querySelectorAll(".action-button-text")[0];
    let iconRightElement = toggleButtonElement.parentElement.querySelector('.display-toggle-icon-right');

    if (iconRightElement) {
        toggleActionsView(toggleButtonElement);
    }

    let elementById;
    let split = elementIdWithIndex.split(':');
    let elementId = split[0];
    let elementIndex = split[1];

    let elementsById = Array.from(errorParentElement.querySelectorAll(`.error.${CSS.escape(elementId)}`));
    if (elementsById.length > 1) {
        elementById = elementsById[elementIndex];
    } else {
        elementById = elementsById[0];
    }

    elementById.scrollIntoView({
        behavior: 'smooth',
        block: 'center',
    });

    let statusLine = elementById;
    console.log("navigateToElementById: ", statusLine.parentElement.parentElement.parentElement);
    statusLine.parentElement.parentElement.click();
}

function isSingleExec() {
    const elements = document.querySelectorAll(".general-report-layout");
    return !playlistsData || (playlistsData.length === 1 && elements.length === 1);
}

const widgetManager = new WidgetManager();
let header = null;
let backToTopButton = null;
processWidowResize();
window.addEventListener('resize', processWidowResize);

window.addEventListener('scroll', () => {
    if (!header) {
        header = document.querySelector('.fixed-header');
    }
    if (window.scrollY > 0) {
        header.classList.add('shadow');
    } else {
        header.classList.remove('shadow');
    }

    if (!backToTopButton) {
        backToTopButton = document.getElementById('back-to-top');
    }

    if (window.scrollY > 100) {
        backToTopButton.classList.add('visible');
    } else {
        backToTopButton.classList.remove('visible');
    }
});

function openImageModal(dataImageHost) {
    isPopupOpened = true;

    const header = document.querySelector('.fixed-header');
    if (header) {
        header.style.display = 'none';
        const backToTop = document.querySelector('#back-to-top');
        backToTop.style.display = 'none';
    }

    document.body.classList.add('noscroll');
    let imageSrc = dataImageHost.childNodes[0].src;
    let imageModal = document.getElementById('imageModal');

    if (imageSrc.includes('video')) {
        imageModal.childNodes[3].src = imageSrc;
        imageModal.childNodes[3].style.display = 'block';
        imageModal.childNodes[1].style.display = 'none';
    } else {
        imageModal.childNodes[1].src = imageSrc;
        imageModal.childNodes[3].style.display = 'none';
        imageModal.childNodes[1].style.display = 'block';
    }

    let contentHeight = document.getElementsByClassName('image-modal-content')[0].height;
    let innerHeight = window.innerHeight - topBegin;
    imageModal.style.display = 'flex';

    if (contentHeight > innerHeight) {
        imageModal.classList.add('image-vertical');
        applyVerticalStyle(imageSrc, imageModal, false);
    } else {
        imageModal.classList.remove('image-vertical');
        applyVerticalStyle(imageSrc, imageModal, true)
    }
}

function closeImageModal() {
    isPopupOpened = false;
    document.body.classList.remove('noscroll');
    let imageModal = document.getElementById('imageModal');
    imageModal.style.display = 'none';

    const header = document.querySelector('.fixed-header');
    if (header) {
        header.style.display = 'block';
        const backToTop = document.querySelector('#back-to-top');
        backToTop.style.display = 'block';
    }
}

window.onload = function () {
    if (document) {
        let jsonData = document.getElementById("playlist-data");
        if (jsonData) {
            playlistsData = JSON.parse(jsonData.textContent);
            widgetManager.fillPlaylists(playlistsData);
            displayTopGRaph();
            widgetManager.unwrapFirstPlayList();
            if (isSingleExec()) {
                widgetManager.navigateToNextTestcase();
            }
        } else {
            activateTestCaseGraph(document.querySelector('.charts-container-chart-element.chart-types'));
        }
        applyTruncationToScriptNamesInAction();
        applyTruncationToTestName();
        applyTruncationToSuiteName();
        applyHeightToIframes();
        displayActionsCountForTestCases();
    }

    let loader = document.getElementById("loader");
    if (loader) {
        document.getElementById("loader").style.display = "none";
        setTimeout(() => {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        }, 100);
    }
}
