function getHtmlWithParents(element) {
  if (!element || element.nodeType !== Node.ELEMENT_NODE) return "";

  // 1. Remonter la chaîne de parents (sans body / html)
  const chain = [];
  let current = element;

  while (current && current.nodeType === Node.ELEMENT_NODE) {
    const tag = current.tagName.toLowerCase();
    if (tag === "body" || tag === "html") break;

    chain.unshift(current); // [plus haut parent, ..., element]
    current = current.parentElement;
  }

  if (chain.length === 0) return "";

  // 2. Construire une arborescence clonée minimale
  //    (on ne clone pas encore le contenu, juste la structure)
  const topClone = chain[0].cloneNode(false);
  let cursor = topClone;

  for (let i = 1; i < chain.length; i++) {
    const clone = chain[i].cloneNode(false);
    cursor.appendChild(clone);
    cursor = clone;
  }

  // 3. Pour le dernier (l’élément cible), on met son innerHTML réel
  cursor.innerHTML = element.innerHTML;

  // 4. Utiliser un wrapper pour récupérer le HTML généré
  const wrapper = document.createElement("div");
  wrapper.appendChild(topClone);

  return wrapper.innerHTML;
}

result = getHtmlWithParents(arguments[0]);