/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

public final class BitSet {
    private long[] bits;
    private static final byte[] nextBitTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    private BitSet(int n) {
        if (n > 0) {
            this.bits = new long[n + 63 >> 6];
        }
    }

    private BitSet(BitSet bitSet) {
        this(BitSet.size(bitSet));
        if (BitSet.size(bitSet) > 0) {
            System.arraycopy(bitSet.bits, 0, this.bits, 0, this.bits.length);
        }
    }

    public static BitSet and(BitSet bitSet, BitSet bitSet2) {
        if (BitSet.isEmpty(bitSet) || BitSet.isEmpty(bitSet2)) {
            return null;
        }
        int n = BitSet.size(bitSet) < BitSet.size(bitSet2) ? BitSet.size(bitSet) : BitSet.size(bitSet2);
        int n2 = n >> 6;
        BitSet bitSet3 = new BitSet(n);
        for (int i = 0; i < n2; ++i) {
            bitSet3.bits[i] = bitSet.bits[i] & bitSet2.bits[i];
        }
        return bitSet3;
    }

    private void reset(BitSet bitSet) {
        int n = (BitSet.size(this) < BitSet.size(bitSet) ? BitSet.size(this) : BitSet.size(bitSet)) >> 6;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] & (bitSet.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static BitSet or(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3;
        block6: {
            int n;
            int n2;
            block5: {
                if (BitSet.isEmpty(bitSet)) {
                    return bitSet2;
                }
                if (BitSet.isEmpty(bitSet2)) {
                    return bitSet;
                }
                n2 = (BitSet.size(bitSet) < BitSet.size(bitSet2) ? BitSet.size(bitSet) : BitSet.size(bitSet2)) >> 6;
                int n3 = (BitSet.size(bitSet) > BitSet.size(bitSet2) ? BitSet.size(bitSet) : BitSet.size(bitSet2)) >> 6;
                bitSet3 = new BitSet(n3 << 6);
                for (n = 0; n < n2; ++n) {
                    bitSet3.bits[n] = bitSet.bits[n] | bitSet2.bits[n];
                }
                if (bitSet.bits == null || bitSet.bits.length <= n2) break block5;
                for (n = bitSet.bits.length - 1; n >= n2; --n) {
                    bitSet3.bits[n] = bitSet.bits[n];
                }
                break block6;
            }
            if (bitSet2.bits == null || bitSet2.bits.length <= n2) break block6;
            for (n = bitSet2.bits.length - 1; n >= n2; --n) {
                bitSet3.bits[n] = bitSet2.bits[n];
            }
        }
        return bitSet3;
    }

    private void set(BitSet bitSet) {
        if (BitSet.size(bitSet) > BitSet.size(this)) {
            long[] lArray = new long[BitSet.size(bitSet) >> 6];
            if (this.bits != null) {
                System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
            }
            this.bits = lArray;
        }
        if (bitSet != null && bitSet.bits != null) {
            for (int i = bitSet.bits.length - 1; i >= 0; --i) {
                int n = i;
                this.bits[n] = this.bits[n] | bitSet.bits[i];
            }
        }
    }

    public static BitSet set(BitSet bitSet, BitSet bitSet2) {
        if (BitSet.size(bitSet2) > 0) {
            if (bitSet == null) {
                bitSet = new BitSet(BitSet.size(bitSet2));
            }
            bitSet.set(bitSet2);
        }
        return bitSet;
    }

    public static BitSet reset_set(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        if (bitSet != null) {
            bitSet.reset(bitSet2);
        }
        if (bitSet3 != null) {
            if (bitSet == null) {
                bitSet = new BitSet(BitSet.size(bitSet3));
            }
            bitSet.set(bitSet3);
        }
        return bitSet;
    }

    public static BitSet xor(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3;
        block6: {
            int n;
            int n2;
            block5: {
                if (BitSet.isEmpty(bitSet)) {
                    return bitSet2;
                }
                if (BitSet.isEmpty(bitSet2)) {
                    return bitSet;
                }
                n2 = (BitSet.size(bitSet) < BitSet.size(bitSet2) ? BitSet.size(bitSet) : BitSet.size(bitSet2)) >> 6;
                int n3 = (BitSet.size(bitSet) > BitSet.size(bitSet2) ? BitSet.size(bitSet) : BitSet.size(bitSet2)) >> 6;
                bitSet3 = new BitSet(n3 << 6);
                for (n = 0; n < n2; ++n) {
                    bitSet3.bits[n] = bitSet.bits[n] ^ bitSet2.bits[n];
                }
                if (bitSet.bits == null || bitSet.bits.length <= n2) break block5;
                for (n = bitSet.bits.length - 1; n >= n2; --n) {
                    bitSet3.bits[n] = bitSet.bits[n];
                }
                break block6;
            }
            if (bitSet2.bits == null || bitSet2.bits.length <= n2) break block6;
            for (n = bitSet2.bits.length - 1; n >= n2; --n) {
                bitSet3.bits[n] = bitSet2.bits[n];
            }
        }
        return bitSet3;
    }

    public static boolean isEmpty(BitSet bitSet) {
        return bitSet == null || bitSet.isEmpty();
    }

    private boolean isEmpty() {
        if (this.bits != null) {
            for (int i = this.bits.length - 1; i >= 0; --i) {
                if (this.bits[i] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    private static int size(BitSet bitSet) {
        return bitSet != null && bitSet.bits != null ? bitSet.bits.length << 6 : 0;
    }

    private boolean get(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new Error();
        }
        int n2 = n >> 6;
        return this.bits != null && n2 < this.bits.length && (this.bits[n2] & 1L << (n & 0x3F)) != 0L;
    }

    public static boolean get(BitSet bitSet, int n) {
        return bitSet != null && bitSet.get(n);
    }

    public static BitSet set(BitSet bitSet, int n, boolean bl) {
        if (!$assertionsDisabled && n < 0) {
            throw new Error();
        }
        int n2 = n >> 6;
        if (n >= BitSet.size(bitSet)) {
            if (bitSet == null) {
                bitSet = new BitSet(n + 1);
            }
            long[] lArray = new long[n2 + 1];
            if (bitSet.bits != null) {
                System.arraycopy(bitSet.bits, 0, lArray, 0, bitSet.bits.length);
            }
            bitSet.bits = lArray;
        }
        if (bl) {
            int n3 = n2;
            bitSet.bits[n3] = bitSet.bits[n3] | 1L << (n & 0x3F);
        } else {
            int n4 = n2;
            bitSet.bits[n4] = bitSet.bits[n4] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return bitSet;
    }

    public static BitSet copy(BitSet bitSet) {
        return bitSet != null && !bitSet.isEmpty() ? new BitSet(bitSet) : null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitSet)) {
            return false;
        }
        return BitSet.equals(this, (BitSet)object);
    }

    public static boolean equals(BitSet bitSet, BitSet bitSet2) {
        int n;
        int n2 = (BitSet.size(bitSet) < BitSet.size(bitSet2) ? BitSet.size(bitSet) : BitSet.size(bitSet2)) >> 6;
        for (n = 0; n < n2; ++n) {
            if (bitSet.bits[n] == bitSet2.bits[n]) continue;
            return false;
        }
        if (bitSet != null && bitSet.bits != null) {
            for (n = bitSet.bits.length - 1; n >= n2; --n) {
                if (bitSet.bits[n] == 0L) continue;
                return false;
            }
        }
        if (bitSet2 != null && bitSet2.bits != null) {
            for (n = bitSet2.bits.length - 1; n >= n2; --n) {
                if (bitSet2.bits[n] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.bits != null) {
            for (int i = this.bits.length - 1; i >= 0; --i) {
                n = (int)((long)n ^ this.bits[i]);
            }
        }
        return n;
    }

    public static int and_count(BitSet bitSet, BitSet bitSet2) {
        int n = (BitSet.size(bitSet) < BitSet.size(bitSet2) ? BitSet.size(bitSet) : BitSet.size(bitSet2)) >> 6;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += BitSet.bitCount(bitSet.bits[i] & bitSet2.bits[i]);
        }
        return n2;
    }

    public static int count(BitSet bitSet) {
        int n = 0;
        if (bitSet != null && bitSet.bits != null) {
            for (int i = bitSet.bits.length - 1; i >= 0; --i) {
                n += BitSet.bitCount(bitSet.bits[i]);
            }
        }
        return n;
    }

    private static int bitCount(long l) {
        l -= (l & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        l = (l & 0x3333333333333333L) + (l >>> 2 & 0x3333333333333333L);
        l = l + (l >>> 4) & 0xF0F0F0F0F0F0F0FL;
        l += l >>> 8;
        l += l >>> 16;
        return (int)l + (int)(l >>> 32) & 0xFF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        if (this.bits != null) {
            int n = this.bits.length << 6;
            for (int i = 0; i < n; ++i) {
                if ((this.bits[i >> 6] & 1L << (i & 0x3F)) == 0L) continue;
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(i);
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static int nextSetBitOld(BitSet bitSet, int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new Error();
        }
        if (bitSet != null && bitSet.bits != null) {
            int n2 = bitSet.bits.length << 6;
            while (n < n2) {
                if ((bitSet.bits[n >> 6] & 1L << (n & 0x3F)) != 0L) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public static int nextSetBit(BitSet bitSet, int n) {
        int n2;
        int n3;
        if (!$assertionsDisabled && n < 0) {
            throw new Error();
        }
        if (bitSet != null && bitSet.bits != null && (n3 = n >> 6) < (n2 = bitSet.bits.length)) {
            long l = bitSet.bits[n3];
            l &= (1L << (n & 0x3F)) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            while (true) {
                if (l != 0L) {
                    if ((l & 0xFFFFFFFFL) != 0L) {
                        if ((l & 0xFFFFL) != 0L) {
                            if ((l & 0xFFL) != 0L) {
                                return nextBitTable[(int)(l & 0xFFL)] + (n3 << 6);
                            }
                            return nextBitTable[(int)(l >> 8 & 0xFFL)] + 8 + (n3 << 6);
                        }
                        if ((l & 0xFF0000L) != 0L) {
                            return nextBitTable[(int)(l >> 16 & 0xFFL)] + 16 + (n3 << 6);
                        }
                        return nextBitTable[(int)(l >> 24 & 0xFFL)] + 24 + (n3 << 6);
                    }
                    if ((l & 0xFFFF00000000L) != 0L) {
                        if ((l & 0xFF00000000L) != 0L) {
                            return nextBitTable[(int)(l >> 32 & 0xFFL)] + 32 + (n3 << 6);
                        }
                        return nextBitTable[(int)(l >> 40 & 0xFFL)] + 40 + (n3 << 6);
                    }
                    if ((l & 0xFF000000000000L) != 0L) {
                        return nextBitTable[(int)(l >> 48 & 0xFFL)] + 48 + (n3 << 6);
                    }
                    return nextBitTable[(int)(l >> 56 & 0xFFL)] + 56 + (n3 << 6);
                }
                if (++n3 >= n2) break;
                l = bitSet.bits[n3];
            }
        }
        return -1;
    }

    static {
        $assertionsDisabled = true;
        nextBitTable = new byte[]{0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    }
}

