/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DVariable;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.util.ArrayUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DValue
implements Value {
    private int m_type;
    private String m_typeName;
    private String m_className;
    private int m_attribs;
    private Map m_members;
    int m_nonProtoId;
    private Object m_value;
    private String[] m_classHierarchy;
    private int m_levelsWithMembers;

    public DValue(long id) {
        this.init(8, null, null, 0, new Long(id));
    }

    public DValue(int type, String typeName, String className, int attribs, Object value) {
        this.init(type, typeName, className, attribs, value);
    }

    private void init(int type, String typeName, String className, int attribs, Object value) {
        this.m_type = type;
        this.m_typeName = typeName;
        this.m_className = className;
        this.m_attribs = attribs;
        this.m_value = value;
        this.m_members = null;
        this.m_nonProtoId = this.getId();
    }

    public int getAttributes() {
        return this.m_attribs;
    }

    public String getClassName() {
        return this.m_className;
    }

    public int getId() {
        if (this.m_value instanceof Long) {
            return ((Long)this.m_value).intValue();
        }
        return -1;
    }

    public int getMemberCount(Session s) throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.obtainMembers(s);
        return this.m_members == null ? 0 : this.m_members.size();
    }

    public Variable getMemberNamed(Session s, String name) throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.obtainMembers(s);
        return this.findMember(name);
    }

    public String[] getClassHierarchy(boolean allLevels) {
        String[] partialClassHierarchy;
        if (allLevels) {
            return this.m_classHierarchy;
        }
        if (this.m_classHierarchy != null) {
            partialClassHierarchy = new String[this.m_levelsWithMembers];
            System.arraycopy(this.m_classHierarchy, 0, partialClassHierarchy, 0, this.m_levelsWithMembers);
        } else {
            partialClassHierarchy = new String[]{};
        }
        return partialClassHierarchy;
    }

    public DVariable findMember(String named) {
        if (this.m_members == null) {
            return null;
        }
        return (DVariable)this.m_members.get(named);
    }

    public Variable[] getMembers(Session s) throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.obtainMembers(s);
        int count = this.getMemberCount(s);
        Object[] ar = new DVariable[count];
        if (count > 0) {
            count = 0;
            Iterator itr = this.m_members.values().iterator();
            while (itr.hasNext()) {
                DVariable sf = (DVariable)itr.next();
                ar[count++] = sf;
            }
            ArrayUtil.sort(ar);
        }
        return ar;
    }

    private void obtainMembers(Session s) throws NotSuspendedException, NoResponseException, NotConnectedException {
        int id;
        if (this.m_members == null && s != null && (id = this.getId()) != -1) {
            if (((PlayerSession)s).getRawValue(id) == this) {
                ((PlayerSession)s).obtainMembers(id);
            }
            if (this.m_members != null) {
                Iterator iter = this.m_members.values().iterator();
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (!(next instanceof DVariable)) continue;
                    ((DVariable)next).setSession(s);
                }
            }
        }
    }

    public boolean membersObtained() {
        return this.getId() == -1 || this.m_members != null;
    }

    public void setMembersObtained(boolean obtained) {
        if (obtained) {
            if (this.m_members == null) {
                this.m_members = Collections.EMPTY_MAP;
            }
        } else {
            this.m_members = null;
        }
    }

    public void addMember(DVariable v) {
        if (this.m_members == null) {
            this.m_members = new HashMap();
        }
        String name = v.getName();
        DValue val = (DValue)v.getValue();
        val.m_nonProtoId = name != null && name.equals("__proto__") ? this.m_nonProtoId : val.getId();
        v.m_nonProtoParentId = this.m_nonProtoId;
        this.m_members.put(name, v);
    }

    public void removeAllMembers() {
        this.m_members = null;
    }

    public int getType() {
        return this.m_type;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public Object getValueAsObject() {
        return this.m_value;
    }

    public String getValueAsString() {
        long longValue;
        double value;
        if (this.m_value == null) {
            return "undefined";
        }
        if (this.m_value instanceof Double && (value = ((Double)this.m_value).doubleValue()) == (double)(longValue = (long)value)) {
            return Long.toString(longValue);
        }
        return this.m_value.toString();
    }

    public boolean isAttributeSet(int variableAttribute) {
        return (this.m_attribs & variableAttribute) != 0;
    }

    public void setTypeName(String s) {
        this.m_typeName = s;
    }

    public void setClassName(String s) {
        this.m_className = s;
    }

    public void setType(int t) {
        this.m_type = t;
    }

    public void setValue(Object o) {
        this.m_value = o;
    }

    public void setAttributes(int f) {
        this.m_attribs = f;
    }

    public void setClassHierarchy(String[] classHierarchy, int levelsWithMembers) {
        this.m_classHierarchy = classHierarchy;
        this.m_levelsWithMembers = levelsWithMembers;
    }

    public String membersToString() {
        StringBuffer sb = new StringBuffer();
        if (this.m_members == null) {
            sb.append(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("empty"));
        } else {
            Iterator itr = this.m_members.values().iterator();
            while (itr.hasNext()) {
                DVariable sf = (DVariable)itr.next();
                sb.append(sf);
                sb.append(",\n");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getValueAsString();
    }
}

