/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphicObjectConverter;
import org.apache.batik.svggen.SVGLine;
import org.w3c.dom.Element;

public class SVGArc
extends SVGGraphicObjectConverter {
    private SVGLine svgLine;

    public SVGArc(SVGGeneratorContext generatorContext) {
        super(generatorContext);
    }

    public Element toSVG(Arc2D arc) {
        if (arc.getWidth() == 0.0 || arc.getHeight() == 0.0) {
            Line2D.Double line = new Line2D.Double(arc.getX(), arc.getY(), arc.getX() + arc.getWidth(), arc.getY() + arc.getHeight());
            if (this.svgLine == null) {
                this.svgLine = new SVGLine(this.generatorContext);
            }
            return this.svgLine.toSVG(line);
        }
        Element svgPath = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "path");
        StringBuffer d = new StringBuffer("");
        Point2D startPt = arc.getStartPoint();
        Point2D endPt = arc.getEndPoint();
        double ext = arc.getAngleExtent();
        int type = arc.getArcType();
        d.append("M");
        d.append(this.doubleString(startPt.getX()));
        d.append(" ");
        d.append(this.doubleString(startPt.getY()));
        d.append(" ");
        d.append("A");
        d.append(this.doubleString(arc.getWidth() / 2.0));
        d.append(" ");
        d.append(this.doubleString(arc.getHeight() / 2.0));
        d.append(" ");
        d.append("0");
        d.append(" ");
        if (ext > 180.0) {
            d.append("1");
        } else {
            d.append("0");
        }
        d.append(" ");
        if (ext > 0.0) {
            d.append("0");
        } else {
            d.append("1");
        }
        d.append(" ");
        d.append(this.doubleString(endPt.getX()));
        d.append(" ");
        d.append(this.doubleString(endPt.getY()));
        if (type == 1) {
            d.append("Z");
        } else if (type == 2) {
            double cx = arc.getX() + arc.getWidth() / 2.0;
            double cy = arc.getY() + arc.getHeight() / 2.0;
            d.append("L");
            d.append(" ");
            d.append(this.doubleString(cx));
            d.append(" ");
            d.append(this.doubleString(cy));
            d.append(" ");
            d.append("Z");
        }
        svgPath.setAttributeNS(null, "d", d.toString());
        return svgPath;
    }
}

