/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.TruncatedFileException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class JPEGRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] sigJPEG = new byte[]{-1, -40, -1};
    static final String[] exts = new String[]{"jpeg", "jpg"};
    static final String[] mimeTypes = new String[]{"image/jpeg", "image/jpg"};
    static final MagicNumberRegistryEntry.MagicNumber[] magicNumbers = new MagicNumberRegistryEntry.MagicNumber[]{new MagicNumberRegistryEntry.MagicNumber(0, sigJPEG)};

    public JPEGRegistryEntry() {
        super("JPEG", exts, mimeTypes, magicNumbers);
    }

    public Filter handleStream(InputStream inIS, ParsedURL origURL, boolean needRawData) {
        Object[] errParam;
        String errCode;
        final DeferRable dr = new DeferRable();
        final InputStream is = inIS;
        if (origURL != null) {
            errCode = "url.format.unreadable";
            errParam = new Object[]{"JPEG", origURL};
        } else {
            errCode = "stream.format.unreadable";
            errParam = new Object[]{"JPEG"};
        }
        Thread t = new Thread(){

            public void run() {
                Filter filt;
                try {
                    BufferedImage image;
                    block4: {
                        JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)is);
                        try {
                            image = decoder.decodeAsBufferedImage();
                        }
                        catch (TruncatedFileException tfe) {
                            image = tfe.getBufferedImage();
                            if (image != null) break block4;
                            throw new IOException("JPEG File was truncated");
                        }
                    }
                    dr.setBounds(new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight()));
                    CachableRed cr = GraphicsUtil.wrap(image);
                    cr = new Any2sRGBRed(cr);
                    cr = new FormatRed(cr, GraphicsUtil.sRGB_Unpre);
                    WritableRaster wr = (WritableRaster)cr.getData();
                    ColorModel cm = cr.getColorModel();
                    image = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
                    cr = GraphicsUtil.wrap(image);
                    filt = new RedRable(cr);
                }
                catch (IOException ioe) {
                    filt = ImageTagRegistry.getBrokenLinkImage(this, errCode, errParam);
                }
                dr.setSource(filt);
            }
        };
        t.start();
        return dr;
    }
}

