////////////////////////////////////////////////////////////////////////////////
//
//  ADOBE SYSTEMS INCORPORATED
//  Copyright 2005-2007 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE: Adobe permits you to use, modify, and distribute this file
//  in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////

package mx.containers
{
    
/**
 *  The FormItemDirection class defines the constant values
 *  for the <code>direction</code> property of the FormItem class.
 *
 *  @see mx.containers.FormItem
 */
public final class FormItemDirection
{
    include "../core/Version.as";

    //--------------------------------------------------------------------------
    //
    //  Class constants
    //
    //--------------------------------------------------------------------------

    /**
     *  Specifies that the children of the FormItem container
     *  are laid out horizontally.
     */
    public static const HORIZONTAL:String = "horizontal";
    
    /**
     *  Specifies that the children of the FormItem container
     *  are laid out vertically.
     */
    public static const VERTICAL:String = "vertical";
}

}
