////////////////////////////////////////////////////////////////////////////////
//
//  ADOBE SYSTEMS INCORPORATED
//  Copyright 2006 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE: Adobe permits you to use, modify, and distribute this file
//  in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////

package mx.utils
{

import flash.display.DisplayObject;
import flash.utils.getQualifiedClassName;
import mx.core.IRepeaterClient;

/**
 *  The NameUtil utility class defines static methods for
 *  creating names for Flex objects.
 *  You do not create instances of NameUtil;
 *  instead you call static methods of the class, such as 
 *  the <code>NameUtil.createName()</code> method.
 */
public class NameUtil
{
	include "../core/Version.as";

	//--------------------------------------------------------------------------
	//
	//  Class variables
	//
	//--------------------------------------------------------------------------

	/**
	 *  @private
	 */
	private static var counter:int = 0;

	//--------------------------------------------------------------------------
	//
	//  Class methods
	//
	//--------------------------------------------------------------------------

	/**
	 *  Creates a unique name for any Object instance, such as "Button12", by
	 *  combining the unqualified class name with an incrementing counter.
	 *
	 *  @param object Object requiring a name.
	 *
	 *  @return String containing the unique name.
	 */
    public static function createUniqueName(object:Object):String
    {
		if (!object)
			return null;

		var name:String = getQualifiedClassName(object);
		
		// If there is a package name, strip it off.
		var index:int = name.indexOf("::");
		if (index != -1)
			name = name.substr(index + 2);
						
		// If the class name ends with a digit (which some autogenerated
		// classes do), then append an underscore before appending
		// the counter.
		var charCode:int = name.charCodeAt(name.length - 1);
		if (charCode >= 48 && charCode <= 57)
			name += "_";
		
		return name + counter++;
    }

	/**
	 *  Returns a string, such as
	 *  "MyApplication0.addressForm.lastName.TextField17",
	 *  for a DisplayObject object that indicates its position in the
	 *  hierarchy of DisplayObject objects in an application.
	 *
	 *  @param displayObject A DisplayObject object whose hierarchy in the application
	 *  is desired. 
	 *
	 *  @return String containing the position of <code>displayObject</code> 
	 *  in the hierarchy of DisplayObject objects in an application.
	 */
	public static function displayObjectToString(
								displayObject:DisplayObject):String
	{
		var result:String;

		// Start at the specified object and walk up the parent chain
		// to build up the string to return.
		for (var o:DisplayObject = displayObject;
			 o != null;
			 o = o.parent)
		{
			// If this object is in the display tree,
			// stop after we've prepended the topmost Application instance.
			if (o.parent && o.stage && o.parent == o.stage)
				break;

			var s:String = o.name;
			
			if (o is IRepeaterClient)
			{
				var indices:Array = IRepeaterClient(o).instanceIndices;
				if (indices)
					s += "[" + indices.join("][") + "]";
			}

			result = result == null ? s : s + "." + result;
		}

		return result;
	}
}

}
