/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.dto.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.convert.converter.Converter;

class TaggingHeaderConverter
implements Converter<String, List<Tag>> {
    private static final Pattern TAGGING_PATTERN = Pattern.compile(".*=.*(&.*=.*)?");

    TaggingHeaderConverter() {
    }

    public List<Tag> convert(String source) {
        ArrayList<Tag> tags = null;
        Matcher matcher = TAGGING_PATTERN.matcher(source);
        if (matcher.matches()) {
            String[] split;
            tags = new ArrayList<Tag>();
            for (String tag : split = source.split("&")) {
                tags.add(new Tag(tag));
            }
        }
        return tags;
    }
}

