/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.s3mock.dto.Checksum;
import com.adobe.testing.s3mock.dto.GetObjectAttributesParts;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.EtagUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import java.util.List;

@JsonRootName(value="GetObjectAttributesOutput")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class GetObjectAttributesOutput {
    @JsonProperty(value="Checksum")
    private Checksum checksum;
    @JsonProperty(value="ETag")
    private String etag;
    @JsonProperty(value="ObjectParts")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<GetObjectAttributesParts> objectParts;
    @JsonProperty(value="ObjectSize")
    private Long objectSize;
    @JsonProperty(value="StorageClass")
    private StorageClass storageClass;

    public GetObjectAttributesOutput(Checksum checksum, String etag, List<GetObjectAttributesParts> objectParts, Long objectSize, StorageClass storageClass) {
        this.checksum = checksum;
        this.etag = EtagUtil.normalizeEtag(etag);
        this.objectParts = objectParts;
        this.objectSize = objectSize;
        this.storageClass = storageClass;
    }

    GetObjectAttributesOutput from(S3ObjectMetadata metadata) {
        return new GetObjectAttributesOutput(null, metadata.getEtag(), null, Long.valueOf(metadata.getSize()), null);
    }
}

