/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.AbstractMojoBase;
import com.agilejava.docbkx.maven.AvalonMavenBridgeLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.messaging.MessageHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.xml.sax.InputSource;

public abstract class AbstractPdfMojo
extends AbstractMojoBase {
    public void postProcessResult(File result) throws MojoExecutionException {
        super.postProcessResult(result);
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.openFileForInput(result);
            out = this.openFileForOutput(this.getOutputFile(result));
            AvalonMavenBridgeLogger logger = new AvalonMavenBridgeLogger(this.getLog(), true, true);
            MessageHandler.setScreenLogger((Logger)logger);
            Driver driver = new Driver(new InputSource(in), out);
            driver.setLogger((Logger)logger);
            driver.setRenderer(1);
            driver.run();
        }
        catch (FOPException fope) {
            throw new MojoExecutionException("Failed to convert to PDF", (Exception)((Object)fope));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to write to output file.");
        }
    }

    private InputStream openFileForInput(File file) throws MojoExecutionException {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new MojoExecutionException("Failed to open " + file + " for input.");
        }
    }

    private File getOutputFile(File inputFile) {
        String basename = FileUtils.basename((String)inputFile.getAbsolutePath());
        return new File(this.getTargetDirectory(), basename + "pdf");
    }

    private OutputStream openFileForOutput(File file) throws MojoExecutionException {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new MojoExecutionException("Failed to open " + file + " for output.");
        }
    }
}

