/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.Collection;
import java.util.HashSet;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.Params;

abstract class WholeHighlighter
extends Highlighter {
    private Collection<String> styles = new HashSet<String>();
    private boolean emptyStyle = true;
    private boolean allStyles = false;

    void loadStyles(Params params) {
        if (!params.isSet("empty")) {
            this.emptyStyle = false;
        }
        if (params.isSet("all")) {
            this.allStyles = true;
            return;
        }
        params.load("style", this.styles);
    }

    boolean appliesOnEmptyStyle() {
        return this.emptyStyle;
    }

    boolean appliesOnAllStyles() {
        return this.allStyles;
    }

    boolean appliesOnStyle(String string) {
        return this.styles.contains(string);
    }

    WholeHighlighter(Params params) {
        if (params != null && params.isSet("applyOnStyles")) {
            this.loadStyles(params.getParams("applyOnStyles"));
        }
    }
}

