/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.advisor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisorChain;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.document.DocumentRetriever;
import org.springframework.ai.model.Content;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DocumentRetrievalAdvisor
implements CallAroundAdvisor,
StreamAroundAdvisor {
    private static final String DEFAULT_USER_TEXT_ADVISE = "Context information is below.\n---------------------\n{question_answer_context}\n---------------------\nGiven the context and provided history information and not prior knowledge,\nreply to the user comment. If the answer is not in the context, inform\nthe user that you can't answer the question.\n";
    private static final int DEFAULT_ORDER = 0;
    public static String RETRIEVED_DOCUMENTS = "question_answer_context";
    private final DocumentRetriever retriever;
    private final String userTextAdvise;
    private final boolean protectFromBlocking;
    private final int order;

    public DocumentRetrievalAdvisor(DocumentRetriever retriever) {
        this(retriever, DEFAULT_USER_TEXT_ADVISE);
    }

    public DocumentRetrievalAdvisor(DocumentRetriever retriever, String userTextAdvise) {
        this(retriever, userTextAdvise, true);
    }

    public DocumentRetrievalAdvisor(DocumentRetriever retriever, String userTextAdvise, boolean protectFromBlocking) {
        this(retriever, userTextAdvise, protectFromBlocking, 0);
    }

    public DocumentRetrievalAdvisor(DocumentRetriever retriever, String userTextAdvise, boolean protectFromBlocking, int order) {
        this.retriever = retriever;
        this.userTextAdvise = userTextAdvise;
        this.protectFromBlocking = protectFromBlocking;
        this.order = order;
    }

    public AdvisedResponse aroundCall(AdvisedRequest advisedRequest, CallAroundAdvisorChain chain) {
        advisedRequest = this.before(advisedRequest);
        AdvisedResponse advisedResponse = chain.nextAroundCall(advisedRequest);
        return this.after(advisedResponse);
    }

    public Flux<AdvisedResponse> aroundStream(AdvisedRequest advisedRequest, StreamAroundAdvisorChain chain) {
        Flux advisedResponses = this.protectFromBlocking ? Mono.just((Object)advisedRequest).publishOn(Schedulers.boundedElastic()).map(this::before).flatMapMany(arg_0 -> ((StreamAroundAdvisorChain)chain).nextAroundStream(arg_0)) : chain.nextAroundStream(this.before(advisedRequest));
        return advisedResponses.map(ar -> {
            if (this.onFinishReason().test((AdvisedResponse)ar)) {
                ar = this.after((AdvisedResponse)ar);
            }
            return ar;
        });
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public int getOrder() {
        return this.order;
    }

    private AdvisedRequest before(AdvisedRequest request) {
        HashMap<String, List> context = new HashMap<String, List>(request.adviseContext());
        List documents = this.retriever.retrieve(request.userText());
        context.put(RETRIEVED_DOCUMENTS, documents);
        String documentContext = documents.stream().map(Content::getContent).collect(Collectors.joining(System.lineSeparator()));
        HashMap<String, String> advisedUserParams = new HashMap<String, String>(request.userParams());
        advisedUserParams.put("question_answer_context", documentContext);
        return AdvisedRequest.from((AdvisedRequest)request).withUserText(request.userText() + System.lineSeparator() + this.userTextAdvise).withUserParams(advisedUserParams).withAdviseContext(context).build();
    }

    private AdvisedResponse after(AdvisedResponse advisedResponse) {
        ChatResponseMetadata.Builder metadataBuilder = ChatResponseMetadata.builder();
        metadataBuilder.withKeyValue(RETRIEVED_DOCUMENTS, advisedResponse.adviseContext().get(RETRIEVED_DOCUMENTS));
        ChatResponseMetadata metadata = advisedResponse.response().getMetadata();
        if (metadata != null) {
            metadataBuilder.withId(metadata.getId());
            metadataBuilder.withModel(metadata.getModel());
            metadataBuilder.withUsage(metadata.getUsage());
            metadataBuilder.withPromptMetadata(metadata.getPromptMetadata());
            metadataBuilder.withRateLimit(metadata.getRateLimit());
            Set entries = metadata.entrySet();
            for (Map.Entry entry : entries) {
                metadataBuilder.withKeyValue((String)entry.getKey(), entry.getValue());
            }
        }
        ChatResponse chatResponse = new ChatResponse(advisedResponse.response().getResults(), metadataBuilder.build());
        return new AdvisedResponse(chatResponse, advisedResponse.adviseContext());
    }

    private Predicate<AdvisedResponse> onFinishReason() {
        return advisedResponse -> advisedResponse.response().getResults().stream().anyMatch(result -> result != null && result.getMetadata() != null && StringUtils.hasText((String)result.getMetadata().getFinishReason()));
    }
}

