/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.api.ApiUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

public class DashScopeImageApi {
    public static final String DEFAULT_IMAGE_MODEL = ImageModel.WANX_V1.getValue();
    private final RestClient restClient;

    public DashScopeImageApi(String apiKey) {
        this("https://dashscope.aliyuncs.com", apiKey, RestClient.builder(), WebClient.builder(), RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public DashScopeImageApi(String apiKey, String workSpaceId) {
        this("https://dashscope.aliyuncs.com", apiKey, workSpaceId, RestClient.builder(), WebClient.builder(), RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public DashScopeImageApi(String baseUrl, String apiKey, String workSpaceId) {
        this(baseUrl, apiKey, workSpaceId, RestClient.builder(), WebClient.builder(), RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public DashScopeImageApi(String baseUrl, String apiKey, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey)).defaultStatusHandler(responseErrorHandler).build();
    }

    public DashScopeImageApi(String baseUrl, String apiKey, String workSpaceId, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey, workSpaceId)).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<DashScopeImageAsyncReponse> submitImageGenTask(DashScopeImageRequest request) {
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/services/aigc/text2image/image-synthesis", new Object[0])).header("X-DashScope-Async", new String[]{"enable"})).body((Object)request).retrieve().toEntity(DashScopeImageAsyncReponse.class);
    }

    public ResponseEntity<DashScopeImageAsyncReponse> getImageGenTaskResult(String taskId) {
        return this.restClient.get().uri("/api/v1/tasks/{task_id}", new Object[]{taskId}).retrieve().toEntity(DashScopeImageAsyncReponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DashScopeImageAsyncReponse(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="output") DashScopeImageAsyncReponseOutput output, @JsonProperty(value="usage") DashScopeImageAsyncReponseUsage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncReponseOutput(@JsonProperty(value="task_id") String taskId, @JsonProperty(value="task_status") String taskStatus, @JsonProperty(value="results") List<DashScopeImageAsyncReponseResult> results, @JsonProperty(value="task_metrics") DashScopeImageAsyncReponseTaskMetrics taskMetrics, @JsonProperty(value="code") String code, @JsonProperty(value="message") String message) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncReponseUsage(@JsonProperty(value="image_count") Integer imageCount) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncReponseResult(@JsonProperty(value="url") String url) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncReponseTaskMetrics(@JsonProperty(value="TOTAL") Integer total, @JsonProperty(value="SUCCEEDED") Integer SUCCEEDED, @JsonProperty(value="FAILED") Integer FAILED) {
        }
    }

    public static enum ImageModel {
        WANX_V1("wanx-v1");

        public final String value;

        private ImageModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DashScopeImageRequest(@JsonProperty(value="model") String model, @JsonProperty(value="input") DashScopeImageRequestInput input, @JsonProperty(value="parameters") DashScopeImageRequestParameter parameters) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageRequestInput(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="negative_prompt") String negativePrompt, @JsonProperty(value="ref_img") String refImg) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageRequestParameter(@JsonProperty(value="style") String style, @JsonProperty(value="size") String size, @JsonProperty(value="n") Integer n, @JsonProperty(value="seed") Integer seed, @JsonProperty(value="ref_strength") Float refStrength, @JsonProperty(value="ref_mode") String refMode) {
        }
    }
}

