/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.audio;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.audio.transcription.AudioTranscriptionOptions;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class DashScopeAudioTranscriptionOptions
implements AudioTranscriptionOptions {
    @JsonProperty(value="model")
    private String model = "paraformer-v2";
    @JsonProperty(value="vocabulary_id")
    private String vocabularyId;
    @JsonProperty(value="phrase_id")
    private String phraseId;
    @JsonProperty(value="sample_rate")
    private Integer sampleRate;
    @JsonProperty(value="format")
    private AudioFormat format;
    @NestedConfigurationProperty
    @JsonProperty(value="channel_id")
    private List<Integer> channelId = List.of(Integer.valueOf(0));
    @JsonProperty(value="disfluency_removal_enabled")
    private Boolean disfluencyRemovalEnabled = false;
    @JsonProperty(value="language_hints")
    private List<String> languageHints = List.of("zh", "en");

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getVocabularyId() {
        return this.vocabularyId;
    }

    public void setVocabularyId(String vocabularyId) {
        this.vocabularyId = vocabularyId;
    }

    public String getPhraseId() {
        return this.phraseId;
    }

    public Integer getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Integer sampleRate) {
        this.sampleRate = sampleRate;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public void setFormat(AudioFormat format) {
        this.format = format;
    }

    public void setPhraseId(String phraseId) {
        this.phraseId = phraseId;
    }

    public List<Integer> getChannelId() {
        return this.channelId;
    }

    public void setChannelId(List<Integer> channelId) {
        this.channelId = channelId;
    }

    public Boolean getDisfluencyRemovalEnabled() {
        return this.disfluencyRemovalEnabled;
    }

    public void setDisfluencyRemovalEnabled(Boolean disfluencyRemovalEnabled) {
        this.disfluencyRemovalEnabled = disfluencyRemovalEnabled;
    }

    public List<String> getLanguageHints() {
        return this.languageHints;
    }

    public void setLanguageHints(List<String> languageHints) {
        this.languageHints = languageHints;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum AudioFormat {
        PCM("pcm"),
        WAV("wav"),
        MP3("mp3"),
        OPUS("opus"),
        SPEEX("speex"),
        AAC("aac"),
        AMR("amr");

        public final String value;

        private AudioFormat(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private final DashScopeAudioTranscriptionOptions options = new DashScopeAudioTranscriptionOptions();

        public Builder withModel(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder withVocabularyId(String vocabularyId) {
            this.options.setVocabularyId(vocabularyId);
            return this;
        }

        public Builder withPhraseId(String phraseId) {
            this.options.setPhraseId(phraseId);
            return this;
        }

        public Builder withSampleRate(Integer sampleRate) {
            this.options.setSampleRate(sampleRate);
            return this;
        }

        public Builder withFormat(AudioFormat format) {
            this.options.setFormat(format);
            return this;
        }

        public Builder withChannelId(List<Integer> channelId) {
            this.options.setChannelId(channelId);
            return this;
        }

        public Builder withDisfluencyRemovalEnabled(Boolean disfluencyRemovalEnabled) {
            this.options.setDisfluencyRemovalEnabled(disfluencyRemovalEnabled);
            return this;
        }

        public Builder withLanguageHints(List<String> languageHints) {
            this.options.setLanguageHints(languageHints);
            return this;
        }

        public DashScopeAudioTranscriptionOptions build() {
            return this.options;
        }
    }
}

