/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import com.amashchenko.maven.plugin.gitflow.GitFlowVersionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

@Mojo(name="version-update", aggregator=true)
public class GitFlowVersionUpdateMojo
extends AbstractGitFlowMojo {
    @Parameter(property="pushRemote", defaultValue="false")
    private boolean pushRemote;
    @Parameter(property="fromBranch")
    private String fromBranch;
    @Parameter(property="updateVersion")
    private String updateVersion;
    @Parameter(property="updateVersionDigitToIncrement")
    private Integer updateVersionDigitToIncrement;
    @Parameter(property="skipTag", defaultValue="false")
    private boolean skipTag = false;
    @Parameter(property="gpgSignTag", defaultValue="false")
    private boolean gpgSignTag = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(new String[0]);
        try {
            String currentVersion;
            String defaultVersion;
            String releaseBranch;
            this.initGitFlowConfig();
            this.checkUncommittedChanges();
            String branchName = releaseBranch = this.gitFindBranches(this.gitFlowConfig.getReleaseBranchPrefix(), false);
            String supportBranchesStr = this.gitFindBranches(this.gitFlowConfig.getSupportBranchPrefix(), false);
            if (StringUtils.isBlank((String)releaseBranch) && StringUtils.isBlank((String)supportBranchesStr)) {
                throw new MojoFailureException("There is no release or support branches.");
            }
            String[] supportBranches = StringUtils.isNotBlank((String)supportBranchesStr) ? supportBranchesStr.split("\\r?\\n") : null;
            if (this.settings.isInteractiveMode()) {
                if (supportBranches != null && supportBranches.length > 0) {
                    String[] branches = new String[supportBranches.length + 1];
                    for (int i = 0; i < supportBranches.length; ++i) {
                        branches[i] = supportBranches[i];
                    }
                    if (StringUtils.isNotBlank((String)releaseBranch)) {
                        branches[supportBranches.length] = releaseBranch;
                    }
                    ArrayList<String> numberedList = new ArrayList<String>();
                    StringBuilder str = new StringBuilder("Branches:").append(LS);
                    for (int i = 0; i < branches.length; ++i) {
                        str.append(i + 1 + ". " + branches[i] + LS);
                        numberedList.add(String.valueOf(i + 1));
                    }
                    str.append("Choose branch to update");
                    String branchNumber = null;
                    try {
                        while (StringUtils.isBlank(branchNumber)) {
                            branchNumber = this.prompter.prompt(str.toString(), numberedList);
                        }
                    }
                    catch (PrompterException e) {
                        throw new MojoFailureException("version-update", (Throwable)e);
                    }
                    if (branchNumber != null) {
                        int num = Integer.parseInt(branchNumber);
                        branchName = branches[num - 1];
                    }
                }
            } else if (StringUtils.isNotBlank((String)this.fromBranch)) {
                if (this.fromBranch.equals(releaseBranch) || this.contains(supportBranches, this.fromBranch)) {
                    branchName = this.fromBranch;
                } else {
                    throw new MojoFailureException("The fromBranch is not release or support branch.");
                }
            }
            if (StringUtils.isBlank((String)branchName)) {
                throw new MojoFailureException("Branch name is blank.");
            }
            this.gitCheckout(branchName);
            if (this.fetchRemote) {
                this.gitFetchRemoteAndCompare(branchName);
            }
            if ((defaultVersion = new GitFlowVersionInfo(currentVersion = this.getCurrentProjectVersion(), this.getVersionPolicy()).hotfixVersion(this.tychoBuild, this.updateVersionDigitToIncrement)) == null) {
                throw new MojoFailureException("Cannot get default next version.");
            }
            String version = null;
            if (this.settings.isInteractiveMode()) {
                try {
                    while (version == null) {
                        version = this.prompter.prompt("What is the update version? [" + defaultVersion + "]");
                        if ("".equals(version) || GitFlowVersionInfo.isValidVersion(version) && this.validBranchName(version)) continue;
                        this.getLog().info((CharSequence)"The version is not valid.");
                        version = null;
                    }
                }
                catch (PrompterException e) {
                    throw new MojoFailureException("version-update", (Throwable)e);
                }
            } else {
                if (!(!StringUtils.isNotBlank((String)this.updateVersion) || GitFlowVersionInfo.isValidVersion(this.updateVersion) && this.validBranchName(this.updateVersion))) {
                    throw new MojoFailureException("The update version '" + this.updateVersion + "' is not valid.");
                }
                version = this.updateVersion;
            }
            if (StringUtils.isBlank(version)) {
                this.getLog().info((CharSequence)"Version is blank. Using default version.");
                version = defaultVersion;
            }
            HashMap<String, String> messageProperties = new HashMap<String, String>();
            if (!version.equals(currentVersion)) {
                this.mvnSetVersions(version);
                messageProperties.put("version", version);
                this.gitCommit(this.commitMessages.getVersionUpdateMessage(), messageProperties);
            }
            if (!this.skipTag) {
                messageProperties.put("version", version);
                this.gitTag(this.gitFlowConfig.getVersionTagPrefix() + version, this.commitMessages.getTagVersionUpdateMessage(), this.gpgSignTag, messageProperties);
            }
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (this.pushRemote) {
                this.gitPush(branchName, !this.skipTag);
            }
        }
        catch (VersionParseException | CommandLineException e) {
            throw new MojoFailureException("version-update", e);
        }
    }

    private boolean contains(String[] arr, String str) {
        if (arr != null && str != null) {
            for (String a : arr) {
                if (!str.equals(a)) continue;
                return true;
            }
        }
        return false;
    }
}

