/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.SupportedInterfaces;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Device {
    @JsonProperty(value="deviceId")
    private String deviceId = null;
    @JsonProperty(value="supportedInterfaces")
    private SupportedInterfaces supportedInterfaces = null;

    public static Builder builder() {
        return new Builder();
    }

    private Device(Builder builder) {
        this.deviceId = builder.deviceId;
        this.supportedInterfaces = builder.supportedInterfaces;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public SupportedInterfaces getSupportedInterfaces() {
        return this.supportedInterfaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return Objects.equals(this.deviceId, device.deviceId) && Objects.equals(this.supportedInterfaces, device.supportedInterfaces);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.supportedInterfaces);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Device {\n");
        sb.append("    deviceId: ").append(this.toIndentedString(this.deviceId)).append("\n");
        sb.append("    supportedInterfaces: ").append(this.toIndentedString(this.supportedInterfaces)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String deviceId;
        private SupportedInterfaces supportedInterfaces;

        private Builder() {
        }

        @JsonProperty(value="deviceId")
        public Builder withDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @JsonProperty(value="supportedInterfaces")
        public Builder withSupportedInterfaces(SupportedInterfaces supportedInterfaces) {
            this.supportedInterfaces = supportedInterfaces;
            return this;
        }

        public Device build() {
            return new Device(this);
        }
    }
}

