/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.Response;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ResponseEnvelope {
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="sessionAttributes")
    private Map<String, Object> sessionAttributes = new HashMap<String, Object>();
    @JsonProperty(value="userAgent")
    private String userAgent = null;
    @JsonProperty(value="response")
    private Response response = null;

    public static Builder builder() {
        return new Builder();
    }

    private ResponseEnvelope(Builder builder) {
        this.version = builder.version;
        this.sessionAttributes = builder.sessionAttributes;
        this.userAgent = builder.userAgent;
        this.response = builder.response;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Object> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Response getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseEnvelope responseEnvelope = (ResponseEnvelope)o;
        return Objects.equals(this.version, responseEnvelope.version) && Objects.equals(this.sessionAttributes, responseEnvelope.sessionAttributes) && Objects.equals(this.userAgent, responseEnvelope.userAgent) && Objects.equals(this.response, responseEnvelope.response);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.sessionAttributes, this.userAgent, this.response);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseEnvelope {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    sessionAttributes: ").append(this.toIndentedString(this.sessionAttributes)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String version;
        private Map<String, Object> sessionAttributes;
        private String userAgent;
        private Response response;

        private Builder() {
        }

        @JsonProperty(value="version")
        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="sessionAttributes")
        public Builder withSessionAttributes(Map<String, Object> sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
            return this;
        }

        public Builder putSessionAttributesItem(String key, Object sessionAttributesItem) {
            if (this.sessionAttributes == null) {
                this.sessionAttributes = new HashMap<String, Object>();
            }
            this.sessionAttributes.put(key, sessionAttributesItem);
            return this;
        }

        @JsonProperty(value="userAgent")
        public Builder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @JsonProperty(value="response")
        public Builder withResponse(Response response) {
            this.response = response;
            return this;
        }

        public ResponseEnvelope build() {
            return new ResponseEnvelope(this);
        }
    }
}

