/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.audioplayer;

import com.amazon.ask.model.Request;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class PlaybackNearlyFinishedRequest
extends Request {
    @JsonProperty(value="offsetInMilliseconds")
    private Long offsetInMilliseconds = null;
    @JsonProperty(value="token")
    private String token = null;

    public static Builder builder() {
        return new Builder();
    }

    private PlaybackNearlyFinishedRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "AudioPlayer.PlaybackNearlyFinished";
        this.requestId = builder.requestId;
        this.timestamp = builder.timestamp;
        this.locale = builder.locale;
        this.offsetInMilliseconds = builder.offsetInMilliseconds;
        this.token = builder.token;
    }

    public Long getOffsetInMilliseconds() {
        return this.offsetInMilliseconds;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaybackNearlyFinishedRequest interfacesAudioplayerPlaybackNearlyFinishedRequest = (PlaybackNearlyFinishedRequest)o;
        return Objects.equals(this.offsetInMilliseconds, interfacesAudioplayerPlaybackNearlyFinishedRequest.offsetInMilliseconds) && Objects.equals(this.token, interfacesAudioplayerPlaybackNearlyFinishedRequest.token) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.offsetInMilliseconds, this.token, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlaybackNearlyFinishedRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    offsetInMilliseconds: ").append(this.toIndentedString(this.offsetInMilliseconds)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private Long offsetInMilliseconds;
        private String token;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="offsetInMilliseconds")
        public Builder withOffsetInMilliseconds(Long offsetInMilliseconds) {
            this.offsetInMilliseconds = offsetInMilliseconds;
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public PlaybackNearlyFinishedRequest build() {
            return new PlaybackNearlyFinishedRequest(this);
        }
    }
}

