/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.display;

import com.amazon.ask.model.interfaces.display.BackButtonBehavior;
import com.amazon.ask.model.interfaces.display.Image;
import com.amazon.ask.model.interfaces.display.ListItem;
import com.amazon.ask.model.interfaces.display.Template;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ListTemplate1
extends Template {
    @JsonProperty(value="backgroundImage")
    private Image backgroundImage = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="listItems")
    private List<ListItem> listItems = new ArrayList<ListItem>();

    public static Builder builder() {
        return new Builder();
    }

    private ListTemplate1(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "ListTemplate1";
        this.token = builder.token;
        this.backButton = builder.backButton;
        this.backgroundImage = builder.backgroundImage;
        this.title = builder.title;
        this.listItems = builder.listItems;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public String getTitle() {
        return this.title;
    }

    public List<ListItem> getListItems() {
        return this.listItems;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTemplate1 interfacesDisplayListTemplate1 = (ListTemplate1)o;
        return Objects.equals(this.backgroundImage, interfacesDisplayListTemplate1.backgroundImage) && Objects.equals(this.title, interfacesDisplayListTemplate1.title) && Objects.equals(this.listItems, interfacesDisplayListTemplate1.listItems) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backgroundImage, this.title, this.listItems, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTemplate1 {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    backgroundImage: ").append(this.toIndentedString(this.backgroundImage)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    listItems: ").append(this.toIndentedString(this.listItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String token;
        private BackButtonBehavior backButton;
        private Image backgroundImage;
        private String title;
        private List<ListItem> listItems;

        private Builder() {
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="backButton")
        public Builder withBackButton(BackButtonBehavior backButton) {
            this.backButton = backButton;
            return this;
        }

        @JsonProperty(value="backgroundImage")
        public Builder withBackgroundImage(Image backgroundImage) {
            this.backgroundImage = backgroundImage;
            return this;
        }

        @JsonProperty(value="title")
        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="listItems")
        public Builder withListItems(List<ListItem> listItems) {
            this.listItems = listItems;
            return this;
        }

        public Builder addListItemsItem(ListItem listItemsItem) {
            if (this.listItems == null) {
                this.listItems = new ArrayList<ListItem>();
            }
            this.listItems.add(listItemsItem);
            return this;
        }

        public ListTemplate1 build() {
            return new ListTemplate1(this);
        }
    }
}

