/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.system;

import com.amazon.ask.model.Application;
import com.amazon.ask.model.Device;
import com.amazon.ask.model.User;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SystemState {
    @JsonProperty(value="application")
    private Application application = null;
    @JsonProperty(value="user")
    private User user = null;
    @JsonProperty(value="device")
    private Device device = null;
    @JsonProperty(value="apiEndpoint")
    private String apiEndpoint = null;
    @JsonProperty(value="apiAccessToken")
    private String apiAccessToken = null;

    public static Builder builder() {
        return new Builder();
    }

    private SystemState(Builder builder) {
        this.application = builder.application;
        this.user = builder.user;
        this.device = builder.device;
        this.apiEndpoint = builder.apiEndpoint;
        this.apiAccessToken = builder.apiAccessToken;
    }

    public Application getApplication() {
        return this.application;
    }

    public User getUser() {
        return this.user;
    }

    public Device getDevice() {
        return this.device;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public String getApiAccessToken() {
        return this.apiAccessToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemState interfacesSystemSystemState = (SystemState)o;
        return Objects.equals(this.application, interfacesSystemSystemState.application) && Objects.equals(this.user, interfacesSystemSystemState.user) && Objects.equals(this.device, interfacesSystemSystemState.device) && Objects.equals(this.apiEndpoint, interfacesSystemSystemState.apiEndpoint) && Objects.equals(this.apiAccessToken, interfacesSystemSystemState.apiAccessToken);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.user, this.device, this.apiEndpoint, this.apiAccessToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SystemState {\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    apiEndpoint: ").append(this.toIndentedString(this.apiEndpoint)).append("\n");
        sb.append("    apiAccessToken: ").append(this.toIndentedString(this.apiAccessToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Application application;
        private User user;
        private Device device;
        private String apiEndpoint;
        private String apiAccessToken;

        private Builder() {
        }

        @JsonProperty(value="application")
        public Builder withApplication(Application application) {
            this.application = application;
            return this;
        }

        @JsonProperty(value="user")
        public Builder withUser(User user) {
            this.user = user;
            return this;
        }

        @JsonProperty(value="device")
        public Builder withDevice(Device device) {
            this.device = device;
            return this;
        }

        @JsonProperty(value="apiEndpoint")
        public Builder withApiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        @JsonProperty(value="apiAccessToken")
        public Builder withApiAccessToken(String apiAccessToken) {
            this.apiAccessToken = apiAccessToken;
            return this;
        }

        public SystemState build() {
            return new SystemState(this);
        }
    }
}

