/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.slu.entityresolution;

import com.amazon.ask.model.slu.entityresolution.Status;
import com.amazon.ask.model.slu.entityresolution.ValueWrapper;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Resolution {
    @JsonProperty(value="authority")
    private String authority = null;
    @JsonProperty(value="status")
    private Status status = null;
    @JsonProperty(value="values")
    private List<ValueWrapper> values = new ArrayList<ValueWrapper>();

    public static Builder builder() {
        return new Builder();
    }

    private Resolution(Builder builder) {
        this.authority = builder.authority;
        this.status = builder.status;
        this.values = builder.values;
    }

    public String getAuthority() {
        return this.authority;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<ValueWrapper> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resolution sluEntityresolutionResolution = (Resolution)o;
        return Objects.equals(this.authority, sluEntityresolutionResolution.authority) && Objects.equals(this.status, sluEntityresolutionResolution.status) && Objects.equals(this.values, sluEntityresolutionResolution.values);
    }

    public int hashCode() {
        return Objects.hash(this.authority, this.status, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Resolution {\n");
        sb.append("    authority: ").append(this.toIndentedString(this.authority)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String authority;
        private Status status;
        private List<ValueWrapper> values;

        private Builder() {
        }

        @JsonProperty(value="authority")
        public Builder withAuthority(String authority) {
            this.authority = authority;
            return this;
        }

        @JsonProperty(value="status")
        public Builder withStatus(Status status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="values")
        public Builder withValues(List<ValueWrapper> values) {
            this.values = values;
            return this;
        }

        public Builder addValuesItem(ValueWrapper valuesItem) {
            if (this.values == null) {
                this.values = new ArrayList<ValueWrapper>();
            }
            this.values.add(valuesItem);
            return this;
        }

        public Resolution build() {
            return new Resolution(this);
        }
    }
}

