/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.thirdparty.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    static final String METADATA_PREFIX = "x-amz-meta-";
    static final String AMAZON_HEADER_PREFIX = "x-amz-";
    static final String ALTERNATIVE_DATE_HEADER = "x-amz-date";
    public static final String DEFAULT_HOST = "s3.amazonaws.com";
    public static final int SECURE_PORT = 443;
    public static final int INSECURE_PORT = 80;
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    static String makeCanonicalString(String method, String bucket, String key, Map<String, String> pathArgs, Map<String, List<String>> headers) {
        return Utils.makeCanonicalString(method, bucket, key, pathArgs, headers, null);
    }

    static String makeCanonicalString(String method, String bucketName, String key, Map<String, String> pathArgs, Map<String, List<String>> headers, String expires) {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(method) + "\n");
        TreeMap<String, String> interestingHeaders = new TreeMap<String, String>();
        if (headers != null) {
            for (String hashKey : headers.keySet()) {
                String lk;
                if (hashKey == null || !(lk = hashKey.toLowerCase()).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith(AMAZON_HEADER_PREFIX)) continue;
                List<String> s = headers.get(hashKey);
                interestingHeaders.put(lk, Utils.concatenateList(s));
            }
        }
        if (interestingHeaders.containsKey(ALTERNATIVE_DATE_HEADER)) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (String headerKey : interestingHeaders.keySet()) {
            if (headerKey.startsWith(AMAZON_HEADER_PREFIX)) {
                buf.append(headerKey).append(':').append((String)interestingHeaders.get(headerKey));
            } else {
                buf.append((String)interestingHeaders.get(headerKey));
            }
            buf.append("\n");
        }
        if (bucketName != null && !bucketName.equals("")) {
            buf.append("/" + bucketName);
        }
        buf.append("/");
        if (key != null) {
            buf.append(key);
        }
        if (pathArgs != null) {
            if (pathArgs.containsKey("acl")) {
                buf.append("?acl");
            } else if (pathArgs.containsKey("torrent")) {
                buf.append("?torrent");
            } else if (pathArgs.containsKey("logging")) {
                buf.append("?logging");
            }
        }
        return buf.toString();
    }

    static String encode(String awsSecretAccessKey, String canonicalString, boolean urlencode) {
        SecretKeySpec signingKey = new SecretKeySpec(awsSecretAccessKey.getBytes(), HMAC_SHA1_ALGORITHM);
        Mac mac = null;
        try {
            mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find sha1 algorithm", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not initialize the MAC algorithm", e);
        }
        String b64 = Base64.encodeBytes(mac.doFinal(canonicalString.getBytes()));
        if (urlencode) {
            return Utils.urlencode(b64);
        }
        return b64;
    }

    static Map<String, String> paramsForListOptions(String prefix, String marker, Integer maxKeys) {
        return Utils.paramsForListOptions(prefix, marker, maxKeys, null);
    }

    static Map<String, String> paramsForListOptions(String prefix, String marker, Integer maxKeys, String delimiter) {
        HashMap<String, String> argParams = new HashMap<String, String>();
        if (prefix != null) {
            argParams.put("prefix", Utils.urlencode(prefix));
        }
        if (marker != null) {
            argParams.put("marker", Utils.urlencode(marker));
        }
        if (delimiter != null) {
            argParams.put("delimiter", Utils.urlencode(delimiter));
        }
        if (maxKeys != null) {
            argParams.put("max-keys", Integer.toString(maxKeys));
        }
        return argParams;
    }

    public static String convertPathArgsHashToString(Map<String, String> pathArgs) {
        StringBuilder pathArgsString = new StringBuilder();
        boolean firstRun = true;
        if (pathArgs != null) {
            for (String argument : pathArgs.keySet()) {
                if (firstRun) {
                    firstRun = false;
                    pathArgsString.append("?");
                } else {
                    pathArgsString.append("&");
                }
                String argumentValue = pathArgs.get(argument);
                pathArgsString.append(argument);
                if (argument == null) continue;
                pathArgsString.append("=");
                pathArgsString.append(argumentValue);
            }
        }
        return pathArgsString.toString();
    }

    static String urlencode(String unencoded) {
        try {
            return URLEncoder.encode(unencoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not url encode to UTF-8", e);
        }
    }

    static XMLReader createXMLReader() {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            try {
                return XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e2) {
                throw new RuntimeException("Couldn't initialize a sax driver for the XMLReader");
            }
        }
    }

    private static String concatenateList(List<String> values) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int size = values.size();
        while (i < size) {
            buf.append(values.get(i).replaceAll("\n", "").trim());
            if (i != size - 1) {
                buf.append(",");
            }
            ++i;
        }
        return buf.toString();
    }
}

