/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.shadow;

import com.amazonaws.services.iot.client.shadow.AbstractAwsIotDevice;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AwsIotJsonSerializer
extends JsonSerializer<AbstractAwsIotDevice> {
    public void serialize(AbstractAwsIotDevice device, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonProcessingException {
        generator.writeStartObject();
        try {
            for (String property : device.getReportedProperties().keySet()) {
                Field field = device.getReportedProperties().get(property);
                Object value = AwsIotJsonSerializer.invokeGetterMethod(device, field);
                generator.writeObjectField(property, value);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        generator.writeEndObject();
    }

    private static Object invokeGetterMethod(Object target, Field field) throws IOException {
        Object value;
        Method method;
        String fieldName = Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
        String getter = "get" + fieldName;
        try {
            method = target.getClass().getMethod(getter, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            if (e instanceof NoSuchMethodException && Boolean.TYPE.equals(field.getType())) {
                getter = "is" + fieldName;
                try {
                    method = target.getClass().getMethod(getter, new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException ie) {
                    throw new IllegalArgumentException(ie);
                }
            }
            throw new IllegalArgumentException(e);
        }
        try {
            value = method.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IOException(e);
        }
        return value;
    }
}

