/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.services.autoscaling.model.InstanceMonitoring;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class LaunchConfiguration
implements Serializable,
Cloneable {
    private String launchConfigurationName;
    private String launchConfigurationARN;
    private String imageId;
    private String keyName;
    private SdkInternalList<String> securityGroups;
    private String classicLinkVPCId;
    private SdkInternalList<String> classicLinkVPCSecurityGroups;
    private String userData;
    private String instanceType;
    private String kernelId;
    private String ramdiskId;
    private SdkInternalList<BlockDeviceMapping> blockDeviceMappings;
    private InstanceMonitoring instanceMonitoring;
    private String spotPrice;
    private String iamInstanceProfile;
    private Date createdTime;
    private Boolean ebsOptimized;
    private Boolean associatePublicIpAddress;
    private String placementTenancy;

    public void setLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
    }

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public LaunchConfiguration withLaunchConfigurationName(String launchConfigurationName) {
        this.setLaunchConfigurationName(launchConfigurationName);
        return this;
    }

    public void setLaunchConfigurationARN(String launchConfigurationARN) {
        this.launchConfigurationARN = launchConfigurationARN;
    }

    public String getLaunchConfigurationARN() {
        return this.launchConfigurationARN;
    }

    public LaunchConfiguration withLaunchConfigurationARN(String launchConfigurationARN) {
        this.setLaunchConfigurationARN(launchConfigurationARN);
        return this;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public LaunchConfiguration withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public LaunchConfiguration withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new SdkInternalList();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new SdkInternalList<String>(securityGroups);
    }

    public LaunchConfiguration withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new SdkInternalList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public LaunchConfiguration withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setClassicLinkVPCId(String classicLinkVPCId) {
        this.classicLinkVPCId = classicLinkVPCId;
    }

    public String getClassicLinkVPCId() {
        return this.classicLinkVPCId;
    }

    public LaunchConfiguration withClassicLinkVPCId(String classicLinkVPCId) {
        this.setClassicLinkVPCId(classicLinkVPCId);
        return this;
    }

    public List<String> getClassicLinkVPCSecurityGroups() {
        if (this.classicLinkVPCSecurityGroups == null) {
            this.classicLinkVPCSecurityGroups = new SdkInternalList();
        }
        return this.classicLinkVPCSecurityGroups;
    }

    public void setClassicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
        if (classicLinkVPCSecurityGroups == null) {
            this.classicLinkVPCSecurityGroups = null;
            return;
        }
        this.classicLinkVPCSecurityGroups = new SdkInternalList<String>(classicLinkVPCSecurityGroups);
    }

    public LaunchConfiguration withClassicLinkVPCSecurityGroups(String ... classicLinkVPCSecurityGroups) {
        if (this.classicLinkVPCSecurityGroups == null) {
            this.setClassicLinkVPCSecurityGroups(new SdkInternalList<String>(classicLinkVPCSecurityGroups.length));
        }
        for (String ele : classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups.add(ele);
        }
        return this;
    }

    public LaunchConfiguration withClassicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
        this.setClassicLinkVPCSecurityGroups(classicLinkVPCSecurityGroups);
        return this;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getUserData() {
        return this.userData;
    }

    public LaunchConfiguration withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public LaunchConfiguration withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public LaunchConfiguration withKernelId(String kernelId) {
        this.setKernelId(kernelId);
        return this;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public LaunchConfiguration withRamdiskId(String ramdiskId) {
        this.setRamdiskId(ramdiskId);
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList<BlockDeviceMapping>(blockDeviceMappings);
    }

    public LaunchConfiguration withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings(new SdkInternalList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add(ele);
        }
        return this;
    }

    public LaunchConfiguration withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setInstanceMonitoring(InstanceMonitoring instanceMonitoring) {
        this.instanceMonitoring = instanceMonitoring;
    }

    public InstanceMonitoring getInstanceMonitoring() {
        return this.instanceMonitoring;
    }

    public LaunchConfiguration withInstanceMonitoring(InstanceMonitoring instanceMonitoring) {
        this.setInstanceMonitoring(instanceMonitoring);
        return this;
    }

    public void setSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
    }

    public String getSpotPrice() {
        return this.spotPrice;
    }

    public LaunchConfiguration withSpotPrice(String spotPrice) {
        this.setSpotPrice(spotPrice);
        return this;
    }

    public void setIamInstanceProfile(String iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public String getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public LaunchConfiguration withIamInstanceProfile(String iamInstanceProfile) {
        this.setIamInstanceProfile(iamInstanceProfile);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public LaunchConfiguration withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public LaunchConfiguration withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.associatePublicIpAddress = associatePublicIpAddress;
    }

    public Boolean getAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public LaunchConfiguration withAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.setAssociatePublicIpAddress(associatePublicIpAddress);
        return this;
    }

    public Boolean isAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public void setPlacementTenancy(String placementTenancy) {
        this.placementTenancy = placementTenancy;
    }

    public String getPlacementTenancy() {
        return this.placementTenancy;
    }

    public LaunchConfiguration withPlacementTenancy(String placementTenancy) {
        this.setPlacementTenancy(placementTenancy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLaunchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(this.getLaunchConfigurationName()).append(",");
        }
        if (this.getLaunchConfigurationARN() != null) {
            sb.append("LaunchConfigurationARN: ").append(this.getLaunchConfigurationARN()).append(",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getKeyName() != null) {
            sb.append("KeyName: ").append(this.getKeyName()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getClassicLinkVPCId() != null) {
            sb.append("ClassicLinkVPCId: ").append(this.getClassicLinkVPCId()).append(",");
        }
        if (this.getClassicLinkVPCSecurityGroups() != null) {
            sb.append("ClassicLinkVPCSecurityGroups: ").append(this.getClassicLinkVPCSecurityGroups()).append(",");
        }
        if (this.getUserData() != null) {
            sb.append("UserData: ").append(this.getUserData()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getKernelId() != null) {
            sb.append("KernelId: ").append(this.getKernelId()).append(",");
        }
        if (this.getRamdiskId() != null) {
            sb.append("RamdiskId: ").append(this.getRamdiskId()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getInstanceMonitoring() != null) {
            sb.append("InstanceMonitoring: ").append(this.getInstanceMonitoring()).append(",");
        }
        if (this.getSpotPrice() != null) {
            sb.append("SpotPrice: ").append(this.getSpotPrice()).append(",");
        }
        if (this.getIamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.getIamInstanceProfile()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized()).append(",");
        }
        if (this.getAssociatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(this.getAssociatePublicIpAddress()).append(",");
        }
        if (this.getPlacementTenancy() != null) {
            sb.append("PlacementTenancy: ").append(this.getPlacementTenancy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfiguration)) {
            return false;
        }
        LaunchConfiguration other = (LaunchConfiguration)obj;
        if (other.getLaunchConfigurationName() == null ^ this.getLaunchConfigurationName() == null) {
            return false;
        }
        if (other.getLaunchConfigurationName() != null && !other.getLaunchConfigurationName().equals(this.getLaunchConfigurationName())) {
            return false;
        }
        if (other.getLaunchConfigurationARN() == null ^ this.getLaunchConfigurationARN() == null) {
            return false;
        }
        if (other.getLaunchConfigurationARN() != null && !other.getLaunchConfigurationARN().equals(this.getLaunchConfigurationARN())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getClassicLinkVPCId() == null ^ this.getClassicLinkVPCId() == null) {
            return false;
        }
        if (other.getClassicLinkVPCId() != null && !other.getClassicLinkVPCId().equals(this.getClassicLinkVPCId())) {
            return false;
        }
        if (other.getClassicLinkVPCSecurityGroups() == null ^ this.getClassicLinkVPCSecurityGroups() == null) {
            return false;
        }
        if (other.getClassicLinkVPCSecurityGroups() != null && !other.getClassicLinkVPCSecurityGroups().equals(this.getClassicLinkVPCSecurityGroups())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getInstanceMonitoring() == null ^ this.getInstanceMonitoring() == null) {
            return false;
        }
        if (other.getInstanceMonitoring() != null && !other.getInstanceMonitoring().equals(this.getInstanceMonitoring())) {
            return false;
        }
        if (other.getSpotPrice() == null ^ this.getSpotPrice() == null) {
            return false;
        }
        if (other.getSpotPrice() != null && !other.getSpotPrice().equals(this.getSpotPrice())) {
            return false;
        }
        if (other.getIamInstanceProfile() == null ^ this.getIamInstanceProfile() == null) {
            return false;
        }
        if (other.getIamInstanceProfile() != null && !other.getIamInstanceProfile().equals(this.getIamInstanceProfile())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getAssociatePublicIpAddress() == null ^ this.getAssociatePublicIpAddress() == null) {
            return false;
        }
        if (other.getAssociatePublicIpAddress() != null && !other.getAssociatePublicIpAddress().equals(this.getAssociatePublicIpAddress())) {
            return false;
        }
        if (other.getPlacementTenancy() == null ^ this.getPlacementTenancy() == null) {
            return false;
        }
        return other.getPlacementTenancy() == null || other.getPlacementTenancy().equals(this.getPlacementTenancy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLaunchConfigurationName() == null ? 0 : this.getLaunchConfigurationName().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchConfigurationARN() == null ? 0 : this.getLaunchConfigurationARN().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getClassicLinkVPCId() == null ? 0 : this.getClassicLinkVPCId().hashCode());
        hashCode = 31 * hashCode + (this.getClassicLinkVPCSecurityGroups() == null ? 0 : this.getClassicLinkVPCSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceMonitoring() == null ? 0 : this.getInstanceMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getSpotPrice() == null ? 0 : this.getSpotPrice().hashCode());
        hashCode = 31 * hashCode + (this.getIamInstanceProfile() == null ? 0 : this.getIamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getAssociatePublicIpAddress() == null ? 0 : this.getAssociatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementTenancy() == null ? 0 : this.getPlacementTenancy().hashCode());
        return hashCode;
    }

    public LaunchConfiguration clone() {
        try {
            return (LaunchConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

