/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.clouddirectory.model.AttributeKey;
import com.amazonaws.services.clouddirectory.model.ObjectReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateIndexRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryArn;
    private List<AttributeKey> orderedIndexedAttributeList;
    private Boolean isUnique;
    private ObjectReference parentReference;
    private String linkName;

    public void setDirectoryArn(String directoryArn) {
        this.directoryArn = directoryArn;
    }

    public String getDirectoryArn() {
        return this.directoryArn;
    }

    public CreateIndexRequest withDirectoryArn(String directoryArn) {
        this.setDirectoryArn(directoryArn);
        return this;
    }

    public List<AttributeKey> getOrderedIndexedAttributeList() {
        return this.orderedIndexedAttributeList;
    }

    public void setOrderedIndexedAttributeList(Collection<AttributeKey> orderedIndexedAttributeList) {
        if (orderedIndexedAttributeList == null) {
            this.orderedIndexedAttributeList = null;
            return;
        }
        this.orderedIndexedAttributeList = new ArrayList<AttributeKey>(orderedIndexedAttributeList);
    }

    public CreateIndexRequest withOrderedIndexedAttributeList(AttributeKey ... orderedIndexedAttributeList) {
        if (this.orderedIndexedAttributeList == null) {
            this.setOrderedIndexedAttributeList(new ArrayList<AttributeKey>(orderedIndexedAttributeList.length));
        }
        for (AttributeKey ele : orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList.add(ele);
        }
        return this;
    }

    public CreateIndexRequest withOrderedIndexedAttributeList(Collection<AttributeKey> orderedIndexedAttributeList) {
        this.setOrderedIndexedAttributeList(orderedIndexedAttributeList);
        return this;
    }

    public void setIsUnique(Boolean isUnique) {
        this.isUnique = isUnique;
    }

    public Boolean getIsUnique() {
        return this.isUnique;
    }

    public CreateIndexRequest withIsUnique(Boolean isUnique) {
        this.setIsUnique(isUnique);
        return this;
    }

    public Boolean isUnique() {
        return this.isUnique;
    }

    public void setParentReference(ObjectReference parentReference) {
        this.parentReference = parentReference;
    }

    public ObjectReference getParentReference() {
        return this.parentReference;
    }

    public CreateIndexRequest withParentReference(ObjectReference parentReference) {
        this.setParentReference(parentReference);
        return this;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public CreateIndexRequest withLinkName(String linkName) {
        this.setLinkName(linkName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.getDirectoryArn()).append(",");
        }
        if (this.getOrderedIndexedAttributeList() != null) {
            sb.append("OrderedIndexedAttributeList: ").append(this.getOrderedIndexedAttributeList()).append(",");
        }
        if (this.getIsUnique() != null) {
            sb.append("IsUnique: ").append(this.getIsUnique()).append(",");
        }
        if (this.getParentReference() != null) {
            sb.append("ParentReference: ").append(this.getParentReference()).append(",");
        }
        if (this.getLinkName() != null) {
            sb.append("LinkName: ").append(this.getLinkName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest)obj;
        if (other.getDirectoryArn() == null ^ this.getDirectoryArn() == null) {
            return false;
        }
        if (other.getDirectoryArn() != null && !other.getDirectoryArn().equals(this.getDirectoryArn())) {
            return false;
        }
        if (other.getOrderedIndexedAttributeList() == null ^ this.getOrderedIndexedAttributeList() == null) {
            return false;
        }
        if (other.getOrderedIndexedAttributeList() != null && !other.getOrderedIndexedAttributeList().equals(this.getOrderedIndexedAttributeList())) {
            return false;
        }
        if (other.getIsUnique() == null ^ this.getIsUnique() == null) {
            return false;
        }
        if (other.getIsUnique() != null && !other.getIsUnique().equals(this.getIsUnique())) {
            return false;
        }
        if (other.getParentReference() == null ^ this.getParentReference() == null) {
            return false;
        }
        if (other.getParentReference() != null && !other.getParentReference().equals(this.getParentReference())) {
            return false;
        }
        if (other.getLinkName() == null ^ this.getLinkName() == null) {
            return false;
        }
        return other.getLinkName() == null || other.getLinkName().equals(this.getLinkName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryArn() == null ? 0 : this.getDirectoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getOrderedIndexedAttributeList() == null ? 0 : this.getOrderedIndexedAttributeList().hashCode());
        hashCode = 31 * hashCode + (this.getIsUnique() == null ? 0 : this.getIsUnique().hashCode());
        hashCode = 31 * hashCode + (this.getParentReference() == null ? 0 : this.getParentReference().hashCode());
        hashCode = 31 * hashCode + (this.getLinkName() == null ? 0 : this.getLinkName().hashCode());
        return hashCode;
    }

    @Override
    public CreateIndexRequest clone() {
        return (CreateIndexRequest)super.clone();
    }
}

