/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.StackStatus;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListStacksRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String nextToken;
    private SdkInternalList<String> stackStatusFilters;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListStacksRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<String> getStackStatusFilters() {
        if (this.stackStatusFilters == null) {
            this.stackStatusFilters = new SdkInternalList();
        }
        return this.stackStatusFilters;
    }

    public void setStackStatusFilters(Collection<String> stackStatusFilters) {
        if (stackStatusFilters == null) {
            this.stackStatusFilters = null;
            return;
        }
        this.stackStatusFilters = new SdkInternalList<String>(stackStatusFilters);
    }

    public ListStacksRequest withStackStatusFilters(String ... stackStatusFilters) {
        if (this.stackStatusFilters == null) {
            this.setStackStatusFilters(new SdkInternalList<String>(stackStatusFilters.length));
        }
        for (String ele : stackStatusFilters) {
            this.stackStatusFilters.add(ele);
        }
        return this;
    }

    public ListStacksRequest withStackStatusFilters(Collection<String> stackStatusFilters) {
        this.setStackStatusFilters(stackStatusFilters);
        return this;
    }

    public ListStacksRequest withStackStatusFilters(StackStatus ... stackStatusFilters) {
        SdkInternalList<String> stackStatusFiltersCopy = new SdkInternalList<String>(stackStatusFilters.length);
        for (StackStatus value : stackStatusFilters) {
            stackStatusFiltersCopy.add(value.toString());
        }
        if (this.getStackStatusFilters() == null) {
            this.setStackStatusFilters(stackStatusFiltersCopy);
        } else {
            this.getStackStatusFilters().addAll(stackStatusFiltersCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getStackStatusFilters() != null) {
            sb.append("StackStatusFilters: ").append(this.getStackStatusFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStacksRequest)) {
            return false;
        }
        ListStacksRequest other = (ListStacksRequest)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getStackStatusFilters() == null ^ this.getStackStatusFilters() == null) {
            return false;
        }
        return other.getStackStatusFilters() == null || other.getStackStatusFilters().equals(this.getStackStatusFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getStackStatusFilters() == null ? 0 : this.getStackStatusFilters().hashCode());
        return hashCode;
    }

    @Override
    public ListStacksRequest clone() {
        return (ListStacksRequest)super.clone();
    }
}

