/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueUpdateMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class AttributeValueUpdate
implements Serializable,
Cloneable,
StructuredPojo {
    private AttributeValue value;
    private String action;

    public AttributeValueUpdate() {
    }

    public AttributeValueUpdate(AttributeValue value, String action) {
        this.setValue(value);
        this.setAction(action);
    }

    public AttributeValueUpdate(AttributeValue value, AttributeAction action) {
        this.setValue(value);
        this.setAction(action.toString());
    }

    public void setValue(AttributeValue value) {
        this.value = value;
    }

    public AttributeValue getValue() {
        return this.value;
    }

    public AttributeValueUpdate withValue(AttributeValue value) {
        this.setValue(value);
        return this;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @JsonProperty(value="action")
    public String getAction() {
        return this.action;
    }

    public AttributeValueUpdate withAction(String action) {
        this.setAction(action);
        return this;
    }

    @JsonIgnore
    public void setAction(AttributeAction action) {
        this.withAction(action);
    }

    public AttributeValueUpdate withAction(AttributeAction action) {
        this.action = action.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValueUpdate)) {
            return false;
        }
        AttributeValueUpdate other = (AttributeValueUpdate)obj;
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        return other.getAction() == null || other.getAction().equals(this.getAction());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        return hashCode;
    }

    public AttributeValueUpdate clone() {
        try {
            return (AttributeValueUpdate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeValueUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

