/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.InstanceAttributeName;
import com.amazonaws.services.ec2.model.transform.DescribeInstanceAttributeRequestMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class DescribeInstanceAttributeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeInstanceAttributeRequest> {
    private String attribute;
    private String instanceId;

    public DescribeInstanceAttributeRequest() {
    }

    public DescribeInstanceAttributeRequest(String instanceId, String attribute) {
        this.setInstanceId(instanceId);
        this.setAttribute(attribute);
    }

    public DescribeInstanceAttributeRequest(String instanceId, InstanceAttributeName attribute) {
        this.setInstanceId(instanceId);
        this.setAttribute(attribute.toString());
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    @JsonProperty(value="attribute")
    public String getAttribute() {
        return this.attribute;
    }

    public DescribeInstanceAttributeRequest withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    @JsonIgnore
    public void setAttribute(InstanceAttributeName attribute) {
        this.withAttribute(attribute);
    }

    public DescribeInstanceAttributeRequest withAttribute(InstanceAttributeName attribute) {
        this.attribute = attribute.toString();
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public DescribeInstanceAttributeRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    @Override
    public Request<DescribeInstanceAttributeRequest> getDryRunRequest() {
        Request<DescribeInstanceAttributeRequest> request = new DescribeInstanceAttributeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttribute() != null) {
            sb.append("Attribute: ").append(this.getAttribute()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAttributeRequest)) {
            return false;
        }
        DescribeInstanceAttributeRequest other = (DescribeInstanceAttributeRequest)obj;
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        if (other.getAttribute() != null && !other.getAttribute().equals(this.getAttribute())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        return other.getInstanceId() == null || other.getInstanceId().equals(this.getInstanceId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        return hashCode;
    }

    @Override
    public DescribeInstanceAttributeRequest clone() {
        return (DescribeInstanceAttributeRequest)super.clone();
    }
}

