/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Attribute;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<Attribute> attributes;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public PutAttributesRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SdkInternalList();
        }
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new SdkInternalList<Attribute>(attributes);
    }

    public PutAttributesRequest withAttributes(Attribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new SdkInternalList<Attribute>(attributes.length));
        }
        for (Attribute ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public PutAttributesRequest withAttributes(Collection<Attribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAttributesRequest)) {
            return false;
        }
        PutAttributesRequest other = (PutAttributesRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    @Override
    public PutAttributesRequest clone() {
        return (PutAttributesRequest)super.clone();
    }
}

