/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.importexport.AmazonImportExportAsync;
import com.amazonaws.services.importexport.AmazonImportExportAsyncClientBuilder;
import com.amazonaws.services.importexport.AmazonImportExportClient;
import com.amazonaws.services.importexport.model.CancelJobRequest;
import com.amazonaws.services.importexport.model.CancelJobResult;
import com.amazonaws.services.importexport.model.CreateJobRequest;
import com.amazonaws.services.importexport.model.CreateJobResult;
import com.amazonaws.services.importexport.model.GetShippingLabelRequest;
import com.amazonaws.services.importexport.model.GetShippingLabelResult;
import com.amazonaws.services.importexport.model.GetStatusRequest;
import com.amazonaws.services.importexport.model.GetStatusResult;
import com.amazonaws.services.importexport.model.ListJobsRequest;
import com.amazonaws.services.importexport.model.ListJobsResult;
import com.amazonaws.services.importexport.model.UpdateJobRequest;
import com.amazonaws.services.importexport.model.UpdateJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonImportExportAsyncClient
extends AmazonImportExportClient
implements AmazonImportExportAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonImportExportAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonImportExportAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonImportExportAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonImportExportAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonImportExportAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonImportExportAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonImportExportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonImportExportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonImportExportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonImportExportAsyncClientBuilder asyncBuilder() {
        return AmazonImportExportAsyncClientBuilder.standard();
    }

    AmazonImportExportAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request) {
        return this.cancelJobAsync(request, null);
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request, final AsyncHandler<CancelJobRequest, CancelJobResult> asyncHandler) {
        final CancelJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                CancelJobResult result = null;
                try {
                    result = AmazonImportExportAsyncClient.this.executeCancelJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request) {
        return this.createJobAsync(request, null);
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request, final AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) {
        final CreateJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                CreateJobResult result = null;
                try {
                    result = AmazonImportExportAsyncClient.this.executeCreateJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetShippingLabelResult> getShippingLabelAsync(GetShippingLabelRequest request) {
        return this.getShippingLabelAsync(request, null);
    }

    @Override
    public Future<GetShippingLabelResult> getShippingLabelAsync(GetShippingLabelRequest request, final AsyncHandler<GetShippingLabelRequest, GetShippingLabelResult> asyncHandler) {
        final GetShippingLabelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetShippingLabelResult>(){

            @Override
            public GetShippingLabelResult call() throws Exception {
                GetShippingLabelResult result = null;
                try {
                    result = AmazonImportExportAsyncClient.this.executeGetShippingLabel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStatusResult> getStatusAsync(GetStatusRequest request) {
        return this.getStatusAsync(request, null);
    }

    @Override
    public Future<GetStatusResult> getStatusAsync(GetStatusRequest request, final AsyncHandler<GetStatusRequest, GetStatusResult> asyncHandler) {
        final GetStatusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetStatusResult>(){

            @Override
            public GetStatusResult call() throws Exception {
                GetStatusResult result = null;
                try {
                    result = AmazonImportExportAsyncClient.this.executeGetStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {
        return this.listJobsAsync(request, null);
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        final ListJobsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result = null;
                try {
                    result = AmazonImportExportAsyncClient.this.executeListJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync() {
        return this.listJobsAsync(new ListJobsRequest());
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        return this.listJobsAsync(new ListJobsRequest(), asyncHandler);
    }

    @Override
    public Future<UpdateJobResult> updateJobAsync(UpdateJobRequest request) {
        return this.updateJobAsync(request, null);
    }

    @Override
    public Future<UpdateJobResult> updateJobAsync(UpdateJobRequest request, final AsyncHandler<UpdateJobRequest, UpdateJobResult> asyncHandler) {
        final UpdateJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateJobResult>(){

            @Override
            public UpdateJobResult call() throws Exception {
                UpdateJobResult result = null;
                try {
                    result = AmazonImportExportAsyncClient.this.executeUpdateJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

