/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mobile.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mobile.model.transform.ResourceMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Resource
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String name;
    private String arn;
    private String feature;
    private Map<String, String> attributes;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Resource withType(String type) {
        this.setType(type);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Resource withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Resource withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public String getFeature() {
        return this.feature;
    }

    public Resource withFeature(String feature) {
        this.setFeature(feature);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Resource withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Resource addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public Resource clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getFeature() != null) {
            sb.append("Feature: ").append(this.getFeature()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getFeature() == null ^ this.getFeature() == null) {
            return false;
        }
        if (other.getFeature() != null && !other.getFeature().equals(this.getFeature())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getFeature() == null ? 0 : this.getFeature().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public Resource clone() {
        try {
            return (Resource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

