/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.conditions;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.stepfunctions.builder.conditions.AndCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.BinaryConditionBuilder;
import com.amazonaws.services.stepfunctions.builder.conditions.BooleanEqualsCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.Condition;
import com.amazonaws.services.stepfunctions.builder.conditions.NotCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericEqualsCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericGreaterThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericGreaterThanOrEqualCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericLessThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericLessThanOrEqualCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.OrCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringEqualsCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringGreaterThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringGreaterThanOrEqualCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringLessThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringLessThanOrEqualCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampEqualsCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampGreaterThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampGreaterThanOrEqualCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampLessThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampLessThanOrEqualCondition;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;

@SdkInternalApi
public class ConditionDeserializer {
    public Condition.Builder deserializeCondition(JsonNode node) {
        if (node.has("Variable")) {
            if (node.has("StringEquals")) {
                return this.deserializeBinaryCondition(StringEqualsCondition.builder(), node);
            }
            if (node.has("StringGreaterThan")) {
                return this.deserializeBinaryCondition(StringGreaterThanCondition.builder(), node);
            }
            if (node.has("StringGreaterThanEquals")) {
                return this.deserializeBinaryCondition(StringGreaterThanOrEqualCondition.builder(), node);
            }
            if (node.has("StringLessThan")) {
                return this.deserializeBinaryCondition(StringLessThanCondition.builder(), node);
            }
            if (node.has("StringLessThanEquals")) {
                return this.deserializeBinaryCondition(StringLessThanOrEqualCondition.builder(), node);
            }
            if (node.has("TimestampEquals")) {
                return this.deserializeBinaryCondition(TimestampEqualsCondition.builder(), node);
            }
            if (node.has("TimestampGreaterThan")) {
                return this.deserializeBinaryCondition(TimestampGreaterThanCondition.builder(), node);
            }
            if (node.has("TimestampGreaterThanEquals")) {
                return this.deserializeBinaryCondition(TimestampGreaterThanOrEqualCondition.builder(), node);
            }
            if (node.has("TimestampLessThan")) {
                return this.deserializeBinaryCondition(TimestampLessThanCondition.builder(), node);
            }
            if (node.has("TimestampLessThanEquals")) {
                return this.deserializeBinaryCondition(TimestampLessThanOrEqualCondition.builder(), node);
            }
            if (node.has("NumericEquals")) {
                return this.deserializeBinaryCondition(NumericEqualsCondition.builder(), node);
            }
            if (node.has("NumericGreaterThan")) {
                return this.deserializeBinaryCondition(NumericGreaterThanCondition.builder(), node);
            }
            if (node.has("NumericGreaterThanEquals")) {
                return this.deserializeBinaryCondition(NumericGreaterThanOrEqualCondition.builder(), node);
            }
            if (node.has("NumericLessThan")) {
                return this.deserializeBinaryCondition(NumericLessThanCondition.builder(), node);
            }
            if (node.has("NumericLessThanEquals")) {
                return this.deserializeBinaryCondition(NumericLessThanOrEqualCondition.builder(), node);
            }
            if (node.has("BooleanEquals")) {
                return this.deserializeBinaryCondition(BooleanEqualsCondition.builder(), node);
            }
        } else {
            if (node.has("And")) {
                AndCondition.Builder builder = AndCondition.builder();
                for (JsonNode inner : node.get("And")) {
                    builder.condition(this.deserializeCondition(inner));
                }
                return builder;
            }
            if (node.has("Or")) {
                OrCondition.Builder builder = OrCondition.builder();
                for (JsonNode inner : node.get("Or")) {
                    builder.condition(this.deserializeCondition(inner));
                }
                return builder;
            }
            if (node.has("Not")) {
                return NotCondition.builder().condition(this.deserializeCondition(node.get("Not")));
            }
        }
        throw new SdkClientException("Condition must be provided");
    }

    private Condition.Builder deserializeBinaryCondition(BinaryConditionBuilder builder, JsonNode node) {
        return builder.variable(node.get("Variable").asText()).expectedValue(node.get(builder.type()));
    }
}

