/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.ion.impl.lite;

import com.amazonaws.thirdparty.ion.IonBlob;
import com.amazonaws.thirdparty.ion.IonType;
import com.amazonaws.thirdparty.ion.IonWriter;
import com.amazonaws.thirdparty.ion.ValueVisitor;
import com.amazonaws.thirdparty.ion.impl.PrivateIonValue;
import com.amazonaws.thirdparty.ion.impl.PrivateUtils;
import com.amazonaws.thirdparty.ion.impl.lite.ContainerlessContext;
import com.amazonaws.thirdparty.ion.impl.lite.IonContext;
import com.amazonaws.thirdparty.ion.impl.lite.IonLobLite;
import java.io.IOException;
import java.io.InputStream;

final class IonBlobLite
extends IonLobLite
implements IonBlob {
    private static final int HASH_SIGNATURE = IonType.BLOB.toString().hashCode();

    IonBlobLite(ContainerlessContext context, boolean isNull) {
        super(context, isNull);
    }

    IonBlobLite(IonBlobLite existing, IonContext context) {
        super(existing, context);
    }

    IonBlobLite clone(IonContext context) {
        return new IonBlobLite(this, context);
    }

    public IonBlobLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        return this.lobHashCode(HASH_SIGNATURE, symbolTableProvider);
    }

    public IonType getType() {
        return IonType.BLOB;
    }

    public void printBase64(Appendable out) throws IOException {
        this.validateThisNotNull();
        InputStream byteStream = this.newInputStream();
        try {
            PrivateUtils.writeAsBase64(byteStream, out);
        }
        finally {
            byteStream.close();
        }
    }

    final void writeBodyTo(IonWriter writer, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        writer.writeBlob(this.getBytesNoCopy());
    }

    public void accept(ValueVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

